/*
 * Decompiled with CFR 0.152.
 */
package xander.core.math;

import java.awt.geom.Rectangle2D;
import xander.core.math.LinearIntercept;
import xander.core.math.VelocityVector;
import xander.core.track.Snapshot;

public class Linear {
    public static LinearIntercept calculateTrajectory(Snapshot target, double initialX, double initialY, double v_p, Rectangle2D.Double bounds, long time) {
        double y;
        Double t2;
        if (target == null) {
            return null;
        }
        double[] velocityComponents = target.getXYShift();
        double v_ex = velocityComponents[0];
        double v_ey = velocityComponents[1];
        double targetInitX = target.getX();
        double targetInitY = target.getY();
        long timeLapse = time - target.getTime();
        if (timeLapse > 0L) {
            targetInitX += v_ex * (double)timeLapse;
            targetInitY += v_ey * (double)timeLapse;
        }
        double s_ex = targetInitX - initialX;
        double s_ey = targetInitY - initialY;
        double v_p2 = v_p * v_p;
        double s_ex2 = s_ex * s_ex;
        double s_ey2 = s_ey * s_ey;
        double v_ey2 = v_ey * v_ey;
        double v_ex2 = v_ex * v_ex;
        double rx = s_ex2 * s_ey2 * v_p2 + s_ex2 * s_ex2 * v_p2 - s_ex2 * s_ex2 * v_ey2 - s_ey2 * v_ex2 * s_ex2 + 2.0 * s_ex2 * s_ex * v_ey * s_ey * v_ex;
        rx = 2.0 * Math.sqrt(rx);
        double xns = -2.0 * s_ey * v_ey * s_ex + 2.0 * v_ex * s_ey2;
        double x1n = xns + rx;
        double x2n = xns - rx;
        double d = 2.0 * (s_ey2 + s_ex2);
        double x1 = x1n / d;
        double x2 = x2n / d;
        double ry = -1.0 * s_ey2 * s_ex2 * v_ey2 + 2.0 * s_ey2 * s_ey * s_ex * v_ey * v_ex - s_ey2 * s_ey2 * v_ex2 + s_ey2 * s_ey2 * v_p2 + s_ex2 * s_ey2 * v_p2;
        ry = 2.0 * Math.sqrt(ry);
        double yns = 2.0 * v_ey * s_ex2 - 2.0 * v_ex * s_ey * s_ex;
        double y1n = yns + ry;
        double y2n = yns - ry;
        double y1 = y1n / d;
        double y2 = y2n / d;
        Double t = Math.abs(x2 - v_ex) < 0.001 ? null : new Double(s_ex / (x2 - v_ex));
        Double d2 = t2 = Math.abs(x1 - v_ex) < 0.001 ? null : new Double(s_ex / (x1 - v_ex));
        if ((t == null || t.isNaN() || t < 0.0) && (t2 == null || t2.isNaN() || t2 < 0.0)) {
            return null;
        }
        double x = t == null || t < 0.0 ? x1 : x2;
        Double ty = Math.abs(y1 - v_ey) < 0.001 ? null : new Double(s_ey / (y1 - v_ey));
        double d3 = y = ty == null || ty < 0.0 ? y2 : y1;
        if (t == null || t < 0.0) {
            t = t2;
        }
        if (bounds != null) {
            double target_x = x * t + initialX;
            double target_y = y * t + initialY;
            if (target_x < bounds.getMinX()) {
                x = (bounds.getMinX() - initialX) / t;
            } else if (target_x > bounds.getMaxX()) {
                x = (bounds.getMaxX() - initialX) / t;
            }
            if (target_y < bounds.getMinY()) {
                y = (bounds.getMinY() - initialY) / t;
            } else if (target_y > bounds.getMaxY()) {
                y = (bounds.getMaxY() - initialY) / t;
            }
        }
        VelocityVector vv = new VelocityVector(x, y, 0.0);
        vv.setMagnitude(v_p);
        return new LinearIntercept(vv, t);
    }
}

