/*
 * Decompiled with CFR 0.152.
 */
package florent.test;

import florent.test.FUtils;
import florent.test.Jumper;
import florent.test.Spitter;
import java.awt.Color;
import java.util.Arrays;
import robocode.AdvancedRobot;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.WinEvent;
import robocode.util.Utils;
import wiki.rmove.RaikoNMT;

public class Toad
extends AdvancedRobot {
    public static final boolean RRGC = false;
    public static final boolean RUMBLE = true;
    public static final boolean MC = false;
    public static final boolean TC = false;
    private static final boolean debug = false;
    private static long lastSkip;
    private static long skipped;
    private static long turns;
    private static long wallHits;
    private static long win;
    private static long lost;
    private static long energy;
    private static long totalTime;
    private static boolean[] rounds;
    private static String log;
    private static Jumper lnkJumper;
    private static Spitter lnkSpitter;
    private RaikoNMT movement;
    private int timeSinceScan = 2;
    private boolean scanned = false;
    private static String name;

    static {
        log = "";
        name = "";
    }

    public void onDeath(DeathEvent e) {
        try {
            if (!rounds[this.getRoundNum()]) {
                ++lost;
            }
            this.endRound();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.log(ex.getLocalizedMessage());
        }
    }

    public void onSkippedTurn(SkippedTurnEvent e) {
        try {
            if (e.getTime() != lastSkip) {
                ++skipped;
            }
            lastSkip = (int)e.getTime();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.log(ex.getLocalizedMessage());
        }
    }

    public void onBulletHit(BulletHitEvent e) {
        try {
            lnkSpitter.onBulletHit(e);
            lnkJumper.onBulletHit(e);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.log(ex.getLocalizedMessage());
        }
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
        try {
            lnkJumper.onBulletHitBullet(e);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ex.printStackTrace();
            this.log(ex.getLocalizedMessage());
        }
    }

    public void onHitByBullet(HitByBulletEvent e) {
        try {
            lnkJumper.onHitByBullet(e);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.log(ex.getLocalizedMessage());
        }
    }

    public void onHitRobot(HitRobotEvent arg0) {
        try {
            lnkJumper.onHitRobot(arg0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.log(ex.getLocalizedMessage());
        }
    }

    public void onHitWall(HitWallEvent arg0) {
        ++wallHits;
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        try {
            name = e.getName();
            this.timeSinceScan = 0;
            this.scanned = true;
            this.setTurnRadarRightRadians(Utils.normalRelativeAngle((double)(this.getHeadingRadians() + e.getBearingRadians() - this.getRadarHeadingRadians())) * 2.0);
            lnkJumper.onScannedRobot(e);
            if (lnkJumper.goHunting() || e.getEnergy() == 0.0) {
                lnkSpitter.holdFire();
            } else {
                lnkSpitter.fireAtWill();
            }
            lnkSpitter.setRammer(lnkJumper.isRammer());
            lnkSpitter.onScannedRobot(e);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.log(ex.getLocalizedMessage());
        }
    }

    public void onWin(WinEvent e) {
        try {
            if (!rounds[this.getRoundNum()]) {
                ++win;
            }
            energy = (long)((double)energy + this.getEnergy());
            this.endRound();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.log(ex.getLocalizedMessage());
        }
    }

    public void run() {
        try {
            if (rounds == null) {
                rounds = new boolean[this.getNumRounds()];
                Arrays.fill(rounds, false);
                try {
                    log = (String)FUtils.restoreObject(this.getDataFile("log"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.status();
            }
            this.setColors(Color.green.darker().darker(), Color.orange.darker(), Color.red);
            lnkSpitter = lnkSpitter == null ? new Spitter() : lnkSpitter;
            lnkJumper = lnkJumper == null ? new Jumper(this) : lnkJumper;
            lnkSpitter.init(this);
            lnkJumper.init(this);
            this.setAdjustGunForRobotTurn(true);
            this.setAdjustRadarForGunTurn(true);
            while (true) {
                lnkJumper.newTick();
                if (this.timeSinceScan++ > 1) {
                    this.setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
                    if (this.scanned) {
                        lnkJumper.move();
                    }
                }
                ++turns;
                this.execute();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.log(ex.getLocalizedMessage());
            return;
        }
    }

    private void endRound() {
        if (rounds[this.getRoundNum()]) {
            return;
        }
        totalTime += this.getTime();
        Toad.rounds[this.getRoundNum()] = true;
        lnkJumper.endRound();
        lnkSpitter.endRound();
        if (this.getRoundNum() == this.getNumRounds() - 1) {
            this.log("Won/Lost:" + win + "/" + lost);
            this.log("Skipped turns :" + skipped + ":" + (double)skipped * 1.0 / ((double)totalTime * 1.0));
            this.log("battle vs " + name + "done\n");
        }
        FUtils.saveObject(log, this.getDataFile("log"));
    }

    private void dump() {
        System.out.println(((Object)((Object)this)).getClass().getName());
        System.out.println("Won/Lost:" + win + "/" + lost);
        System.out.println("Skipped turns :" + skipped + ":" + (double)skipped * 1.0 / ((double)totalTime * 1.0));
        System.out.println("Wall hits :" + wallHits);
        System.out.println("Average energy on win:" + (double)energy / ((double)win * 1.0));
        lnkSpitter.dump();
        lnkJumper.dump();
    }

    public Thread giveThread(Runnable run) {
        return new Thread(run);
    }

    public void stopThread(Thread p) {
        p.stop();
    }

    public void log(String s) {
        try {
            return;
        }
        catch (Exception e) {
            System.out.println(e);
            return;
        }
    }

    public void status() {
        System.out.println("RUMBLE:true");
        System.out.println("RRGC:false");
        System.out.println("MC:false");
        System.out.println("TC:false");
    }
}

