/*
 * Decompiled with CFR 0.152.
 */
package krillr.mega.predictors;

import java.awt.Color;
import java.awt.geom.Ellipse2D;
import java.util.Vector;
import krillr.mega.utils.DebugShape;
import krillr.mega.utils.KrillrRobot;
import krillr.mega.utils.KrillrUtil;
import krillr.mega.utils.Point2d;
import krillr.mega.utils.Predictor;
import krillr.mega.utils.UnitInfo;
import krillr.mega.utils.UnitTracker;
import krillr.mega.utils.Vector2d;
import robocode.util.Utils;

public class KrillrFactor
extends Predictor {
    static int DistancesFromSelf = 6;
    static int DistancesWest = 6;
    static int DistancesEast = 6;
    static int DistancesNorth = 6;
    static int DistancesSouth = 6;
    static int RelativeYVelocities = 3;
    static int RelativeXVelocities = 3;
    static int UniqueBins = 31;
    static double[][][][][][][][] Statistics = new double[DistancesFromSelf][DistancesWest][DistancesEast][DistancesNorth][DistancesSouth][RelativeXVelocities][RelativeYVelocities][UniqueBins];
    static Vector waves = new Vector();

    public KrillrFactor(KrillrRobot b, UnitTracker t) {
        this.bot = b;
        this.parentUnit = t;
    }

    public void update() {
        UnitInfo info = this.parentUnit.info();
        Point2d myLocation = this.bot.location();
        Vector2d waveVector = new Vector2d(11.0, info.bearing(myLocation));
        int distanceFromSelf = Math.abs((int)info.distance(myLocation) / 200);
        int distanceFromWest = Math.abs((int)this.bot.westWall.ptLineDist(myLocation) / 200);
        int distanceFromEast = Math.abs((int)this.bot.eastWall.ptLineDist(myLocation) / 200);
        int distanceFromNorth = Math.abs((int)this.bot.northWall.ptLineDist(myLocation) / 200);
        int distanceFromSouth = Math.abs((int)this.bot.southWall.ptLineDist(myLocation) / 200);
        int relativeXVelocity = Math.abs((int)(info.relativeVector.normalized().xForce + 1.0));
        int relativeYVelocity = Math.abs((int)(info.relativeVector.normalized().yForce + 1.0));
        double[] currentBin = Statistics[distanceFromSelf][distanceFromWest][distanceFromEast][distanceFromNorth][distanceFromSouth][relativeXVelocity][relativeYVelocity];
        waves.add(new KrillrWave(info.location, waveVector, this.bot.getTime(), currentBin, this.parentUnit));
    }

    public double predictBearing() {
        UnitInfo info = this.parentUnit.info();
        int bestindex = 15;
        Point2d myLocation = this.bot.location();
        int distanceFromSelf = Math.abs((int)info.distance(myLocation) / 200);
        int distanceFromWest = Math.abs((int)this.bot.westWall.ptLineDist(myLocation) / 200);
        int distanceFromEast = Math.abs((int)this.bot.eastWall.ptLineDist(myLocation) / 200);
        int distanceFromNorth = Math.abs((int)this.bot.northWall.ptLineDist(myLocation) / 200);
        int distanceFromSouth = Math.abs((int)this.bot.southWall.ptLineDist(myLocation) / 200);
        int relativeXVelocity = Math.abs((int)(info.relativeVector.normalized().xForce + 1.0));
        int relativeYVelocity = Math.abs((int)(info.relativeVector.normalized().yForce + 1.0));
        double[] currentBin = Statistics[distanceFromSelf][distanceFromWest][distanceFromEast][distanceFromNorth][distanceFromSouth][relativeXVelocity][relativeYVelocity];
        for (int i = 0; i < UniqueBins; ++i) {
            if (!(currentBin[bestindex] < currentBin[i])) continue;
            bestindex = i;
        }
        this.bot.debug(currentBin[bestindex]);
        double guessfactor = (double)(bestindex - (Statistics.length - 1) / 2) / (double)((Statistics.length - 1) / 2);
        double angleOffset = guessfactor * KrillrUtil.maxEscapeAngle(11.0);
        return Utils.normalRelativeAngle((double)(info.bearing(this.bot.location()) + angleOffset));
    }

    public void checkWaves() {
        for (int i = 0; i < waves.size(); ++i) {
            KrillrWave wave = (KrillrWave)waves.get(i);
            wave.progress();
            wave.draw();
            if (wave.hasHit()) {
                waves.remove(wave);
                --i;
            }
            if (!wave.hasMissed()) continue;
            waves.remove(wave);
            --i;
        }
    }

    public void handleTurn(long t) {
        this.checkWaves();
    }

    class KrillrWave {
        Point2d startLocation;
        Vector2d vector;
        long fireTime;
        double[] mySegment;
        UnitTracker target;
        Ellipse2D.Double waveCircle;

        public KrillrWave() {
        }

        public KrillrWave(Point2d loc, Vector2d vec, long time, double[] seg, UnitTracker t) {
            this.startLocation = loc;
            this.vector = vec;
            this.fireTime = time;
            this.mySegment = seg;
            this.target = t;
            this.waveCircle = new Ellipse2D.Double(loc.x, loc.y, 0.0, 0.0);
        }

        public void progress() {
            this.waveCircle = new Ellipse2D.Double(this.waveCircle.x - this.vector.magnitude(), this.waveCircle.y - this.vector.magnitude(), this.waveCircle.width + this.vector.magnitude() * 2.0, this.waveCircle.height + this.vector.magnitude() * 2.0);
        }

        public boolean hasHit() {
            Point2d enemyLocation = this.target.info().location;
            double rectX = enemyLocation.x - 18.0;
            double rectY = enemyLocation.x - 18.0;
            if (this.waveCircle.intersects(rectX, rectY, 36.0, 36.0)) {
                int index;
                double desiredDirection = this.startLocation.bearing(enemyLocation);
                double angleOffset = Utils.normalRelativeAngle((double)(desiredDirection - this.vector.angle()));
                double guessFactor = Math.max(-1.0, Math.min(1.0, angleOffset / KrillrUtil.maxEscapeAngle(this.vector.magnitude())));
                int n = index = (int)Math.round((double)((this.mySegment.length - 1) / 2) * (guessFactor + 1.0));
                this.mySegment[n] = this.mySegment[n] + 1.0;
                return true;
            }
            return false;
        }

        public boolean hasMissed() {
            Point2d enemyLocation = this.target.info().location;
            double rectX = enemyLocation.x - 18.0;
            double rectY = enemyLocation.x - 18.0;
            if (this.waveCircle.contains(rectX, rectY, 36.0, 36.0)) {
                int index;
                double desiredDirection = this.startLocation.bearing(enemyLocation);
                double angleOffset = Utils.normalRelativeAngle((double)(desiredDirection - this.vector.angle()));
                double guessFactor = Math.max(-1.0, Math.min(1.0, angleOffset / KrillrUtil.maxEscapeAngle(this.vector.magnitude())));
                int n = index = (int)Math.round((double)((this.mySegment.length - 1) / 2) * (guessFactor + 1.0));
                this.mySegment[n] = this.mySegment[n] - 1.0;
                return true;
            }
            return false;
        }

        public void draw() {
            KrillrFactor.this.bot.shapeList.add(new DebugShape(this.waveCircle, new Color(255, 0, 255)));
        }
    }
}

