/*
 * Decompiled with CFR 0.152.
 */
package demetrix.movement;

import demetrix.info.EnemyInfo;
import demetrix.info.SelfInfo;
import demetrix.misc.Const;
import demetrix.movement.Step;
import java.awt.geom.Point2D;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SnG {
    private static final double DISTANCE = 80.0;
    private int direction;
    private double moveX;
    private double moveY;
    private int nextStopTime;
    private double velocity;

    private final double getTangentFactor(double distance) {
        if (distance < 250.0) {
            return 1.1;
        }
        if (distance > 350.0) {
            return 0.8;
        }
        return 1.0;
    }

    public Step execute(SelfInfo self, EnemyInfo enemy) {
        if (this.velocity == 0.0 && enemy.isEnemyShoots()) {
            this.nextStopTime = 30;
        }
        if (this.velocity != 0.0 && enemy.isEnemyShoots()) {
            this.nextStopTime = 2;
        }
        if (this.nextStopTime > 0) {
            --this.nextStopTime;
            this.velocity = 8.0;
        } else {
            this.velocity = 0.0;
        }
        double tangent = enemy.getAbsoluteBearing() + (double)this.direction * Math.PI / (double)2 * this.getTangentFactor(enemy.getDistance());
        double X = self.getPosition().getX();
        double Y = self.getPosition().getY();
        this.moveX = X + 80.0 * Math.sin(tangent);
        this.moveY = Y + 80.0 * Math.cos(tangent);
        if (Const.MOVING_FIELD.contains(this.moveX, this.moveY)) {
            return new Step(new Point2D.Double(this.moveX, this.moveY), this.velocity, this.direction);
        }
        double nextDirectionCW = tangent;
        double nextDirectionCCW = tangent;
        double totalAngle = 0.0;
        do {
            nextDirectionCW += 0.08;
            nextDirectionCCW -= 0.08;
            if ((totalAngle += 0.08) > Math.toRadians(45.0)) {
                this.direction = -this.direction;
                tangent = enemy.getAbsoluteBearing() + (double)this.direction * Math.PI / (double)2;
                this.moveX = X + 80.0 * Math.sin(tangent);
                this.moveY = Y + 80.0 * Math.cos(tangent);
                break;
            }
            this.moveX = X + 80.0 * Math.sin(nextDirectionCW);
            this.moveY = Y + 80.0 * Math.cos(nextDirectionCW);
            if (Const.MOVING_FIELD.contains(this.moveX, this.moveY)) break;
            this.moveX = X + 80.0 * Math.sin(nextDirectionCCW);
            this.moveY = Y + 80.0 * Math.cos(nextDirectionCCW);
        } while (!Const.MOVING_FIELD.contains(this.moveX, this.moveY));
        return new Step(new Point2D.Double(this.moveX, this.moveY), this.velocity, this.direction);
    }

    public void initiate() {
        this.direction = Math.random() < 0.5 ? 1 : -1;
    }

    private final /* synthetic */ void this() {
        this.nextStopTime = 0;
        this.velocity = 0.0;
    }

    public SnG() {
        this.this();
    }
}

