/*
 * Decompiled with CFR 0.152.
 */
package sqTank.util;

import java.awt.geom.Point2D;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Vector;
import robocode.RobocodeFileOutputStream;
import robocode.ScannedRobotEvent;
import robocode.TeamRobot;
import robocode.util.Utils;
import sqTank.libsvm.SVMHelper;
import sqTank.neuralib.NeuralNetwork;
import sqTank.util.Wave;

public class WaveHelper {
    Vector<Wave> waves = new Vector();
    TeamRobot bot = null;
    boolean useSVM = false;
    boolean useNN = false;
    public SVMHelper svm;
    public NeuralNetwork nn;
    public String enemyName = "";
    int trainSize = 0;
    public boolean initFlag = false;
    public boolean load = false;

    public static double[] buildInput(Wave wave) {
        double[] retval = new double[]{wave.linePreDiffAngle, wave.distance, wave.distanceToCenter, wave.startPoint.x, wave.startPoint.y, wave.absBearing, wave.velocity, wave.power, wave.willHitDiffAngle};
        return retval;
    }

    public void init(String model, int inputSize, int hidden, int outputSize, TeamRobot bot, String enemyName) {
        if (this.initFlag) {
            return;
        }
        this.initFlag = true;
        this.enemyName = enemyName;
        if (model.equals("SVM")) {
            this.useSVM = true;
            this.bot = bot;
            this.svm = new SVMHelper(inputSize, outputSize, bot);
            this.svm.init();
            this.loadFile();
        }
        if (model.equals("NN")) {
            this.useNN = true;
            this.bot = bot;
            int[] layout = new int[]{inputSize, hidden, outputSize};
            this.loadFile();
            if (this.load) {
                this.trainSize = 100;
            }
            if (!this.load) {
                this.nn = new NeuralNetwork(layout);
            }
        }
    }

    public void wave(ScannedRobotEvent e) {
        double edistance;
        long time = this.bot.getTime();
        Object nextP = null;
        Point2D.Double myPos = new Point2D.Double(this.bot.getX(), this.bot.getY());
        double absBearing = Utils.normalRelativeAngle((double)(e.getBearingRadians() + this.bot.getHeadingRadians()));
        double moveDistance = edistance = e.getDistance();
        Point2D.Double enemyPos = WaveHelper.nextPoint(myPos, absBearing, moveDistance);
        Point2D.Double nowEnemyPos = WaveHelper.nextPoint(myPos, absBearing, moveDistance);
        Point2D.Double centerPos = new Point2D.Double(this.bot.getBattleFieldWidth() / 2.0, this.bot.getBattleFieldHeight() / 2.0);
        this.bot.setTurnRadarRightRadians(Math.sin(absBearing - this.bot.getRadarHeadingRadians()));
        double catchPower = Math.min(3, 1);
        double firedPower = 0.0;
        int wavesSize = this.waves.size();
        int i = wavesSize - 1;
        while (i >= 0) {
            this.waves.elementAt(i).test(enemyPos, time);
            --i;
        }
        double power = 1.0;
        power = 1.0;
        if (e.getDistance() <= 200.0) {
            power = 2.0;
        }
        if (e.getDistance() <= 100.0) {
            power = 3.0;
        }
        if (this.bot.getEnergy() < 5.0) {
            power = 0.1;
        }
        firedPower = e.getVelocity();
        double angelsq = e.getHeadingRadians() - absBearing;
        Wave curWave = new Wave(myPos, power, time, absBearing, edistance, firedPower * Math.sin(angelsq), enemyPos.distance(centerPos));
        this.waves.add(curWave);
        double preDiffAngle = 0.0;
        int pth = -1;
        if (this.bot.getGunHeat() < 0.4) {
            double matchValue = Double.POSITIVE_INFINITY;
            int i2 = 74;
            while (i2 < wavesSize) {
                double comVal = 0.0;
                double comValD = 0.0;
                Wave wave = this.waves.elementAt(i2);
                Wave tw = this.waves.elementAt(wavesSize);
                wave.clean(time);
                if (wave.hit && wave.enable) {
                    int j = 0;
                    double div = 0.0;
                    double diffAngle = wave.willHitDiffAngle;
                    comVal = comValD = Math.pow((power - wave.power) / 9.0, 2.0);
                    do {
                        div = div * 2.0 + 1.0;
                        comVal += Wave.getComVal(this.waves.elementAt(wavesSize - j), this.waves.elementAt(i2 - j), 1.0) / div;
                        comValD += Wave.getComVal(this.waves.elementAt(wavesSize - j), this.waves.elementAt(i2 - j), -1.0) / div;
                    } while ((j += 6) < 73);
                    if (comValD < comVal) {
                        comVal = comValD;
                        diffAngle = -wave.willHitDiffAngle;
                    }
                    pth = i2;
                    if (comVal < matchValue) {
                        enemyPos = WaveHelper.nextPoint(myPos, absBearing + diffAngle, wave.velocity);
                        if (this.distanceToWall(enemyPos) >= 18.0) {
                            matchValue = comVal;
                            preDiffAngle = diffAngle;
                            power = catchPower;
                        }
                        double[] input = WaveHelper.buildInput(wave);
                        double[] output = new double[]{diffAngle};
                        if (this.useNN) {
                            this.nn.train(input, output);
                        } else if (this.useSVM) {
                            this.svm.addPointListWithOutScale(input, output);
                        }
                        ++this.trainSize;
                    }
                }
                ++i2;
            }
        }
        double orign = preDiffAngle;
        preDiffAngle = Utils.normalRelativeAngle((double)(this.bot.getGunHeadingRadians() - absBearing - preDiffAngle));
        double[] input = WaveHelper.buildInput(curWave);
        double[] output = new double[]{orign};
        double distance = e.getDistance();
        power = curWave.power;
        if (this.trainSize >= 5 || this.load) {
            if (this.useNN) {
                output = this.nn.forwardPass(input);
            } else if (this.useSVM) {
                output = this.svm.getOutput(input);
            }
            double turnAngel = this.bot.getGunHeadingRadians() - absBearing - output[0];
            if (turnAngel > Math.PI * 2) {
                turnAngel -= Math.PI * 2;
            }
            if (turnAngel > Math.PI) {
                turnAngel -= Math.PI * 2;
            }
            if (nowEnemyPos.x < this.bot.getX()) {
                this.bot.setTurnGunLeftRadians(turnAngel);
            } else {
                this.bot.setTurnGunLeftRadians(this.bot.getGunHeadingRadians() - absBearing - output[0]);
            }
            power = 1.0;
            if (e.getDistance() <= 200.0) {
                power = 2.0;
            }
            if (e.getDistance() <= 100.0) {
                power = 3.0;
            }
            if (this.bot.getEnergy() < 5.0) {
                power = 0.1;
            }
            if (this.bot.getGunTurnRemaining() < 3.0 && e.getEnergy() > 0.0) {
                this.bot.setFire(power);
            }
        }
    }

    public double distanceToWall(Point2D.Double p) {
        return Math.min(Math.min(p.x, this.bot.getBattleFieldWidth() - p.x), Math.min(p.y, this.bot.getBattleFieldHeight() - p.y));
    }

    public static Point2D.Double nextPoint(Point2D.Double originPoint, double angle, double distance) {
        return new Point2D.Double(originPoint.x + Math.sin(angle) * distance, originPoint.y + Math.cos(angle) * distance);
    }

    public void saveFile() {
        if (this.useSVM) {
            this.saveSVM();
        }
        if (this.useNN) {
            this.saveNN();
        }
    }

    public void loadFile() {
        if (this.useSVM) {
            this.loadSVM();
        }
        if (this.useNN) {
            this.loadNN();
        }
    }

    public void loadSVM() {
        this.svm.loadSVMModel(this.enemyName);
        this.load = true;
    }

    public void saveSVM() {
        this.svm.saveSVMModel(this.enemyName);
    }

    public boolean saveNN() {
        try {
            System.out.println("saveNN " + this.enemyName);
            RobocodeFileOutputStream fos = new RobocodeFileOutputStream(this.bot.getDataFile(String.valueOf(this.enemyName) + ".zip"));
            ObjectOutputStream oos = new ObjectOutputStream((OutputStream)fos);
            oos.writeObject(this.nn);
            oos.close();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void loadNN() {
        try {
            System.out.println("loadNN " + this.enemyName);
            FileInputStream is = new FileInputStream(this.bot.getDataFile(String.valueOf(this.enemyName) + ".zip"));
            ObjectInputStream oos = new ObjectInputStream(is);
            this.nn = (NeuralNetwork)oos.readObject();
            oos.close();
            this.load = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private final String fileName(String s) {
        int i = s.indexOf(" ");
        if (i != -1) {
            return String.valueOf(s.substring(0, i)) + ".nn";
        }
        return String.valueOf(s) + ".nn";
    }
}

