/*
 * Decompiled with CFR 0.152.
 */
package pa3k;

import pa3k.BulletTracking;
import pa3k.Gun;
import pa3k.Log;
import pa3k.Opponent;
import pa3k.Position;
import pa3k.Tracking;
import robocode.AdvancedRobot;
import robocode.Robot;

public class BestAngleGun
extends Gun {
    protected int waiting;
    protected double lastHitProbability;
    protected long targetReevaluate;

    public BestAngleGun(AdvancedRobot robot, Tracking tracking) {
        super(robot, tracking);
    }

    @Override
    public void init() {
        this.waiting = 0;
        this.lastHitProbability = 0.0;
    }

    @Override
    public void turn() {
        int scanPrio;
        Position futurePos = new Position((Robot)this.robot);
        futurePos.modify(1L, this.robot.getVelocity(), this.robot.getHeadingRadians());
        if (this.targetReevaluate <= 0L || this.target == null || this.target.lastSeen(this.robot.getTime()) > 3L) {
            this.targetReevaluate = 30L;
            Object[] ops = this.tracking.getTargets();
            double bestP = 0.0;
            int i = 0;
            while (i < ops.length) {
                Opponent o = (Opponent)ops[i];
                if (o.lastSeen(this.robot.getTime()) < 3L) {
                    BulletTracking bt = new BulletTracking(1.8, futurePos, o, this.robot.getTime());
                    double angleP = bt.getRandomHitProbability();
                    double hitP = o.getSelfAiming().getHittingRatio();
                    if (this.tracking.getLastHitBy() == o) {
                        hitP += 0.4;
                    }
                    Log.log(3, "Opponent " + o + ", r. hit prob. " + angleP + ", hit history " + hitP);
                    if (!(bestP < angleP + hitP)) break;
                    bestP = angleP + hitP;
                    this.target = o;
                    this.lastHitProbability = angleP;
                    break;
                }
                ++i;
            }
            if (this.target != null) {
                this.tracking.setOpponentOfInterest(this.target);
                Log.log(2, "Targeting " + this.target + " random hit probability " + this.lastHitProbability);
            }
        }
        if (this.target != null && this.newBullet == null && (scanPrio = this.target.getScanPriority(this.robot.getTime())) != -1 && scanPrio < 2) {
            BulletTracking bt = new BulletTracking(1.8, futurePos, this.target, this.robot.getTime());
            double hitP = bt.getRandomHitProbability();
            assert (hitP != Double.NaN);
            if (this.robot.getGunHeat() == 0.0 && (this.waiting == 0 || this.lastHitProbability > hitP || hitP > 0.4)) {
                double energy = 1.8;
                if (hitP > 0.09) {
                    energy = 2.4;
                }
                if (hitP > 0.15) {
                    energy = 3.0;
                }
                if (hitP < 0.05) {
                    energy = 0.6;
                }
                if (energy > this.robot.getEnergy() - 0.1) {
                    energy = this.robot.getEnergy() - 0.1;
                }
                if (energy >= 0.1) {
                    double energyNeeded = this.target.getLastEnergy() / 4.0;
                    if (energyNeeded < energy && (energy = energyNeeded) < 0.1) {
                        energy = 0.1;
                    }
                    this.newBullet = bt = this.target.getSelfAiming().getBestAimingAngle(futurePos, this.target, energy, this.robot.getTime());
                    this.waiting = 15;
                }
            } else if (this.waiting > 0) {
                --this.waiting;
            }
            this.lastHitProbability = hitP;
        }
        --this.targetReevaluate;
        super.turn();
    }
}

