/*
 * Decompiled with CFR 0.152.
 */
package mahrgell;

import java.awt.geom.Point2D;
import robocode.AdvancedRobot;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class mahrram
extends AdvancedRobot {
    static robotData me;
    static robotData enemy;

    private static Point2D.Double skalarToP(skalar movement) {
        return new Point2D.Double(Math.sin(movement.heading) * movement.velocity, Math.cos(movement.heading) * movement.velocity);
    }

    private static Point2D.Double P_Add(Point2D.Double a, Point2D.Double b) {
        return new Point2D.Double(a.x + b.x, a.y + b.y);
    }

    private static Point2D.Double P_Sub(Point2D.Double a, Point2D.Double b) {
        return new Point2D.Double(a.x - b.x, a.y - b.y);
    }

    private static Point2D.Double P_Mult(Point2D.Double pos, double factor) {
        return new Point2D.Double(pos.x * factor, pos.y * factor);
    }

    private static double P_Angle(Point2D.Double vec) {
        return Math.atan2(vec.x, vec.y);
    }

    private static Point2D.Double P_Predict(Point2D.Double pos, skalar movement, double turns) {
        return mahrram.P_Add(pos, mahrram.P_Mult(mahrram.skalarToP(movement), turns));
    }

    private void updateMe() {
        me = new robotData();
        mahrram.me.pos = new Point2D.Double(this.getX(), this.getY());
        mahrram.me.movement = new skalar(this.getHeadingRadians(), this.getVelocity());
    }

    private void updateEnemy(ScannedRobotEvent e) {
        enemy = new robotData();
        mahrram.enemy.pos = mahrram.P_Add(mahrram.me.pos, mahrram.skalarToP(new skalar(e.getBearingRadians() + this.getHeadingRadians(), e.getDistance())));
        mahrram.enemy.movement = new skalar(e.getHeadingRadians(), e.getVelocity());
    }

    public void run() {
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustGunForRobotTurn(true);
        enemy = null;
        while (true) {
            if (enemy == null) {
                this.setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
            } else {
                this.adjustRadar();
            }
            this.execute();
        }
    }

    public void adjustRadar() {
        double radarangle = Utils.normalRelativeAngle((double)(mahrram.P_Angle(mahrram.P_Sub(enemy.Predict(1.0), me.Predict(1.0))) - this.getRadarHeadingRadians()));
        this.setTurnRadarRightRadians(radarangle + Math.signum(radarangle) * 0.1);
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.updateMe();
        this.updateEnemy(e);
        this.adjustRadar();
        double turnangle = Utils.normalRelativeAngle((double)(mahrram.P_Angle(mahrram.P_Sub(enemy.Predict((int)Math.min(10.0, e.getDistance() / this.getVelocity())), mahrram.me.pos)) - this.getHeadingRadians()));
        this.setTurnRightRadians(turnangle);
        this.setAhead(200.0);
        double firepower = Math.max(0.1, Math.min(3.0, Math.min(300.0 / e.getDistance(), this.getEnergy() / 2.0)));
        double gunangle = Utils.normalRelativeAngle((double)(mahrram.P_Angle(mahrram.P_Sub(enemy.Predict((double)((int)e.getDistance()) / Rules.getBulletSpeed((double)firepower) + 1.0), me.Predict(1.0))) - this.getGunHeadingRadians()));
        this.setTurnGunRightRadians(gunangle);
        if (Math.abs(gunangle) < 0.2) {
            this.setFire(firepower);
        }
        this.execute();
    }

    public class robotData {
        Point2D.Double pos;
        skalar movement;

        public Point2D.Double Predict(double dt) {
            return mahrram.P_Predict(this.pos, this.movement, dt);
        }
    }

    public class skalar {
        double heading;
        double velocity;

        public skalar(double head, double velo) {
            this.heading = head;
            this.velocity = velo;
        }
    }
}

