/*
 * Decompiled with CFR 0.152.
 */
package deo.virtual;

import deo.virtual.AdvancedEnemyBot;
import deo.virtual.BulletData;
import deo.virtual.Demension;
import deo.virtual.Util;
import java.awt.geom.Rectangle2D;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;

class RobotData {
    private static final double VELOCITY_FACTOR = 0.3;
    private static final double HEADING_FACTOR = 0.4;
    private static final double SHOTS_FACTOR = 0.3;
    private AdvancedEnemyBot knowledge;
    private String name;
    private double energy;
    private double trackedEnergy;
    private double gunHeat;
    private double gunCoolingRate;
    private double x;
    private double y;
    private double lastX;
    private double lastY;
    private Rectangle2D.Double rectangle;
    private double distance;
    private double heading;
    private double direction;
    private double velocity;
    private double lastVelocity;
    private double angularVelocity;
    private double lastAngularVelocity;
    private int orbitDirection;
    private int timeSinceLastAcceleration;
    private int timeSinceLastDeceleration;
    private long time;
    private double maxVelocity;
    private double averageVelocity;
    private double averageHeading;
    private double minVelocity;
    private double averageAngularVelocity;
    private double averageFirePower;
    private int shots;
    private double minX;
    private double minY;
    private double maxX;
    private double maxY;
    private boolean alive;
    private boolean empty;

    public RobotData(AdvancedEnemyBot knowledge1, String s, double d, double d1, double d2, double d3, double d4) {
        this.knowledge = knowledge1;
        this.name = s;
        this.minX = d;
        this.minY = d1;
        this.maxX = d2;
        this.maxY = d3;
        this.averageVelocity = 0.0;
        this.averageHeading = 0.0;
        this.averageAngularVelocity = 0.0;
        this.timeSinceLastAcceleration = 0;
        this.timeSinceLastDeceleration = 0;
        this.velocity = 0.0;
        this.angularVelocity = 0.0;
        this.orbitDirection = 0;
        this.gunHeat = 0.0;
        this.gunCoolingRate = d4;
        this.averageFirePower = 2.0;
        this.shots = 0;
        this.alive = true;
        this.empty = true;
        this.rectangle = null;
    }

    public BulletData startTick() {
        BulletData bulletdata = null;
        double d = this.trackedEnergy - this.energy;
        if (Math.abs(d) > 1.0E-4 && (!this.knowledge.inactivityTimerExpired() || Math.abs(d - 0.1) > 1.0E-4)) {
            this.knowledge.updateEnergyChange(this.time);
        }
        if (!this.empty && (!this.knowledge.inactivityTimerExpired() || Math.abs(d - 0.1) > 1.0E-4) && (d > 0.0999 || d > 1.0E-4 && this.energy < 1.0E-4)) {
            double d1 = -1.0;
            boolean flag = false;
            if (d <= 0.0999 && this.energy < 1.0E-4) {
                d1 = d;
            } else {
                if (d > 0.1 && this.velocity == 0.0 && Math.abs(this.lastVelocity) > 1.999 && (this.x < this.minX + 2.0 || this.y < this.minY + 2.0 || this.x > this.maxX - 2.0 || this.y > this.maxY - 2.0) && (d > 3.0001 || d > this.averageFirePower + 0.5)) {
                    flag = true;
                    if ((d -= Math.abs(this.lastVelocity) * 0.5 - 1.0) > this.averageFirePower + 0.25 && Math.abs(this.lastVelocity) < 7.001) {
                        d -= 0.5;
                    } else if (Math.abs(this.lastVelocity) > 3.999 && d < this.averageFirePower - 0.5 && d < 2.001) {
                        d += 1.0;
                    } else if (Math.abs(this.lastVelocity) > 2.999 && d < this.averageFirePower - 0.25 && d < 2.501) {
                        d += 0.5;
                    }
                    if (d < 0.0) {
                        d = 0.0;
                    }
                }
                if (d > 0.099 && d < 3.001) {
                    d1 = Util.confine(d, 0.1, 3.0);
                }
            }
            if (d1 > 0.0) {
                bulletdata = new BulletData(this.name, this.lastX, this.lastY, d1, !this.alive || flag, this.knowledge.owner.getX(), this.knowledge.owner.getY(), this.knowledge.owner.getHeading(), this.knowledge.owner.getVelocity(), this.knowledge.getOldAcceleration(), this.time - 1L);
                this.averageFirePower = this.averageFirePower * 0.7 + d1 * 0.3;
                ++this.shots;
                this.gunHeat = 1.0 + d1 / 5.0;
            } else {
                this.gunHeat = Math.min(0.0, this.gunHeat - this.gunCoolingRate);
            }
        } else {
            this.gunHeat = Math.min(0.0, this.gunHeat - this.gunCoolingRate);
        }
        this.trackedEnergy = this.energy;
        return bulletdata;
    }

    public void update(ScannedRobotEvent scannedrobotevent, double d, double d1, double d2) {
        if (!scannedrobotevent.getName().equals(this.name)) {
            Util.addWarning("RobotFile.update: event (" + scannedrobotevent.getName() + ") is not about this robot (" + this.name + ").");
            return;
        }
        if (!this.empty && this.time >= scannedrobotevent.getTime()) {
            return;
        }
        if (this.empty) {
            this.trackedEnergy = scannedrobotevent.getEnergy();
        }
        this.energy = scannedrobotevent.getEnergy();
        double d3 = Math.toRadians(d2 + scannedrobotevent.getBearing());
        this.distance = scannedrobotevent.getDistance();
        this.lastX = this.x;
        this.lastY = this.y;
        this.x = d + Math.sin(d3) * scannedrobotevent.getDistance();
        this.y = d1 + Math.cos(d3) * scannedrobotevent.getDistance();
        if (this.rectangle == null) {
            this.rectangle = new Rectangle2D.Double();
        }
        this.rectangle.setRect(this.x - 19.0, this.y - 19.0, 38.0, 38.0);
        this.lastVelocity = this.velocity;
        this.velocity = scannedrobotevent.getVelocity();
        this.lastAngularVelocity = this.angularVelocity;
        if (Math.abs(this.velocity) > 1.0E-4) {
            double d4 = Util.relativeAngle(Math.toDegrees(d3) + 90.0, scannedrobotevent.getHeading());
            if (Math.abs(d4) < 90.0) {
                this.orbitDirection = 1;
            }
            if (Math.abs(d4) > 90.0) {
                this.orbitDirection = -1;
            }
            if (this.velocity < 0.0) {
                this.orbitDirection *= -1;
            }
        }
        ++this.timeSinceLastAcceleration;
        ++this.timeSinceLastDeceleration;
        if (Math.abs(this.velocity) - Math.abs(this.lastVelocity) > 0.5) {
            this.timeSinceLastAcceleration = 0;
        } else if (Math.abs(this.velocity) - Math.abs(this.lastVelocity) < -0.5) {
            this.timeSinceLastDeceleration = 0;
        }
        if (this.empty) {
            this.maxVelocity = this.velocity;
            this.minVelocity = this.velocity;
            this.averageVelocity = this.velocity;
            this.averageHeading = scannedrobotevent.getHeading();
        } else {
            if (this.velocity > this.maxVelocity) {
                this.maxVelocity = this.velocity;
            }
            if (this.velocity < this.minVelocity) {
                this.minVelocity = this.velocity;
            }
            this.averageVelocity = this.averageVelocity * 0.7 + this.velocity * 0.3;
            this.averageHeading = this.averageHeading * 0.6 + (this.averageHeading + Util.relativeAngle(this.averageHeading, scannedrobotevent.getHeading())) * 0.4;
            this.angularVelocity = Math.toRadians(Util.relativeAngle(this.direction, d2 + scannedrobotevent.getBearing()) / (double)(scannedrobotevent.getTime() - this.time)) * scannedrobotevent.getDistance();
            this.averageAngularVelocity = this.averageAngularVelocity * 0.7 + this.angularVelocity * 0.3;
        }
        this.heading = scannedrobotevent.getHeading();
        this.direction = d2 + scannedrobotevent.getBearing();
        this.time = scannedrobotevent.getTime();
        this.empty = false;
    }

    public void update(BulletHitEvent bullethitevent) {
        if (!bullethitevent.getName().equals(this.name)) {
            Util.addWarning("RobotFile.update: event (" + bullethitevent.getName() + ") is not about this robot (" + this.name + ").");
            return;
        }
        if (this.alive || this.gunHeat > 1.0E-4 || this.trackedEnergy < 1.0E-4) {
            this.trackedEnergy -= Util.getBulletDamage(bullethitevent.getBullet().getPower());
        } else {
            double d = this.averageFirePower;
            if (d < this.trackedEnergy - Util.getBulletDamage(bullethitevent.getBullet().getPower())) {
                d = this.trackedEnergy - Util.getBulletDamage(bullethitevent.getBullet().getPower());
            }
            if (d < 0.1) {
                d = 0.1;
            }
            if (d > this.trackedEnergy) {
                d = this.trackedEnergy;
            }
            this.trackedEnergy = d;
        }
        if (this.empty || this.time >= bullethitevent.getTime()) {
            return;
        }
        this.energy = bullethitevent.getEnergy();
    }

    public void update(HitByBulletEvent hitbybulletevent) {
        if (!hitbybulletevent.getName().equals(this.name)) {
            Util.addWarning("RobotFile.update: event (" + hitbybulletevent.getName() + ") is not about this robot (" + this.name + ").");
            return;
        }
        if (this.alive) {
            this.trackedEnergy += hitbybulletevent.getPower() * 3.0;
            if (this.empty || this.time >= hitbybulletevent.getTime()) {
                return;
            }
            this.energy += hitbybulletevent.getPower() * 3.0;
        }
    }

    public void update(HitRobotEvent hitrobotevent) {
        if (!hitrobotevent.getName().equals(this.name)) {
            Util.addWarning("RobotFile.update: event (" + hitrobotevent.getName() + ") is not about this robot (" + this.name + ").");
            return;
        }
        this.trackedEnergy -= 0.6;
        if (this.empty || this.time >= hitrobotevent.getTime()) {
            return;
        }
        this.energy = hitrobotevent.getEnergy();
    }

    public void update(RobotDeathEvent robotdeathevent) {
        if (!robotdeathevent.getName().equals(this.name)) {
            Util.addWarning("RobotFile.update: event (" + robotdeathevent.getName() + ") is not about this robot (" + this.name + ").");
            return;
        }
        this.alive = false;
        this.energy = 0.0;
        this.velocity = 0.0;
    }

    public Demension guessPosition() {
        return this.guessPosition(this.knowledge.getTime());
    }

    public Demension guessPosition(long l) {
        if (this.empty) {
            Util.addWarning("RobotFile.guessPosition: No data for movement prediction available (" + this.name + ").");
            return new Demension(0.0, 0.0);
        }
        double d = this.x;
        double d1 = this.y;
        if (Math.abs(this.velocity) >= 1.0E-4 && l > this.time) {
            d += Util.confine(Math.sin(Math.toRadians(this.heading)) * this.velocity * (double)(l - this.time), this.minX, this.maxX);
            d1 += Util.confine(Math.cos(Math.toRadians(this.heading)) * this.velocity * (double)(l - this.time), this.minY, this.maxY);
        }
        return new Demension(d, d1);
    }

    public final String getName() {
        return this.name;
    }

    public final double getEnergy() {
        if (this.empty) {
            return 0.0;
        }
        return this.energy;
    }

    public final double getX() {
        if (this.empty) {
            return 0.0;
        }
        return this.x;
    }

    public final double getY() {
        if (this.empty) {
            return 0.0;
        }
        return this.y;
    }

    public final boolean intersects(double d, double d1, double d2, double d3) {
        if (this.rectangle == null) {
            return false;
        }
        return this.rectangle.intersectsLine(d, d1, d2, d3);
    }

    public final double getDistance() {
        if (this.empty) {
            return 0.0;
        }
        return this.distance;
    }

    public final double getHeading() {
        if (this.empty) {
            return 0.0;
        }
        return this.heading;
    }

    public final double getVelocity() {
        if (this.empty) {
            return 0.0;
        }
        return this.velocity;
    }

    public final int getTimeSinceLastAcceleration() {
        return this.timeSinceLastAcceleration;
    }

    public final int getTimeSinceLastDeceleration() {
        return this.timeSinceLastDeceleration;
    }

    public final int getAcceleration() {
        if (this.empty) {
            return 0;
        }
        if (this.velocity > this.lastVelocity + 0.5) {
            return 1;
        }
        return this.velocity >= this.lastVelocity - 0.5 ? 0 : -1;
    }

    public final double getLastVelocity() {
        return this.lastVelocity;
    }

    public final int getOrbitDirection() {
        return this.orbitDirection;
    }

    public final double getAngularVelocity() {
        return this.angularVelocity;
    }

    public final int getAngularAcceleration() {
        if (this.empty) {
            return 0;
        }
        if (this.angularVelocity > this.lastAngularVelocity + 0.5) {
            return 1;
        }
        return this.angularVelocity >= this.lastAngularVelocity - 0.5 ? 0 : -1;
    }

    public final long getTime() {
        if (this.empty) {
            return 0L;
        }
        return this.time;
    }

    public final boolean isEmpty() {
        return this.empty;
    }

    public final double getAverageVelocity() {
        return this.averageVelocity;
    }

    public final double getAverageHeading() {
        return this.averageHeading;
    }

    public final double getAverageAngularVelocity() {
        return this.averageAngularVelocity;
    }

    public final double getAverageFirePower() {
        return this.averageFirePower;
    }

    public final boolean isAlive() {
        return this.alive;
    }
}

