/*
 * Decompiled with CFR 0.152.
 */
package elvbot;

import java.awt.Color;
import java.util.Random;
import robocode.AdvancedRobot;
import robocode.Condition;
import robocode.CustomEvent;
import robocode.HitWallEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class ElverionBot
extends AdvancedRobot {
    Random r = new Random();
    Condition conditionRadar;
    Condition conditionRotateFire;
    boolean rotateFire = false;
    double escape = 1.0;

    public void run() {
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustRadarForRobotTurn(true);
        this.setRadarColor(Color.RED);
        this.setGunColor(Color.GREEN);
        this.addCustomEvent(new Condition("RadarRotate"){

            public boolean test() {
                return ElverionBot.this.getRadarTurnRemaining() < 1.0;
            }
        });
        this.setTurnRadarRight(30.0);
        while (true) {
            this.execute();
        }
    }

    public void onCustomEvent(CustomEvent customEvent) {
        Condition condition = customEvent.getCondition();
        String string = condition.getName();
        if (string.equals("Fire")) {
            this.rotateFire = false;
            this.removeCustomEvent(condition);
            this.fire(1.0);
        } else if (string.equals("RadarRotate")) {
            this.setTurnRadarRight(30.0);
        } else if (string.equals("MoveFromFire")) {
            this.removeCustomEvent(condition);
            this.setAhead(this.escape * 50.0);
        }
    }

    public void onScannedRobot(ScannedRobotEvent scannedRobotEvent) {
        if (!this.rotateFire) {
            this.rotateFire = true;
            double d = Utils.normalRelativeAngleDegrees((double)(scannedRobotEvent.getBearing() + this.getHeading() - this.getGunHeading()));
            this.setTurnGunRight(d);
            this.addCustomEvent(new Condition("Fire"){

                public boolean test() {
                    return ElverionBot.this.getGunTurnRemaining() == 0.0;
                }
            });
            d = Utils.normalRelativeAngleDegrees((double)(scannedRobotEvent.getBearing() + 90.0));
            this.addCustomEvent(new Condition("MoveFromFire"){

                public boolean test() {
                    return ElverionBot.this.getGunTurnRemaining() == 0.0;
                }
            });
            this.setTurnRight(d);
        }
    }

    public void onHitWall(HitWallEvent hitWallEvent) {
        this.escape = -this.escape;
    }
}

