/*
 * Decompiled with CFR 0.152.
 */
package rdt.Debug;

import java.util.Vector;
import rdt.Debug.Debug;

public class DebugCounterStat {
    private String _counterName = null;
    private long _totalRoundCount = 0L;
    private long _totalBattleCount = 0L;
    private Vector<CounterStatField> _fields = null;

    public DebugCounterStat(String countername) {
        this._counterName = countername;
        this._totalRoundCount = 0L;
        this._totalBattleCount = 0L;
        this._fields = new Vector();
    }

    public void StartOfRound() {
        if (!Debug.IsEnabled()) {
            return;
        }
        int count = 0;
        while (count < this._fields.size()) {
            CounterStatField field = this._fields.get(count);
            if (field != null) {
                field.RoundCount = 0L;
            }
            ++count;
        }
        this._totalRoundCount = 0L;
    }

    public void EndOfRound() {
        if (!Debug.IsEnabled()) {
            return;
        }
        System.out.println("Usage stats for " + this._counterName + ":");
        int count = 0;
        while (count < this._fields.size()) {
            CounterStatField field = this._fields.get(count);
            if (field != null) {
                double roundPercentage = (double)field.RoundCount / (double)this._totalRoundCount * 100.0;
                double battlePercentage = (double)field.BattleCount / (double)this._totalBattleCount * 100.0;
                System.out.println("   *" + field.FieldName + ": " + roundPercentage + " / " + battlePercentage);
            }
            ++count;
        }
    }

    public void IncrementCount(String fieldname) {
        if (!Debug.IsEnabled()) {
            return;
        }
        int count = 0;
        while (count < this._fields.size()) {
            CounterStatField field = this._fields.get(count);
            if (field != null && fieldname.equals(field.FieldName)) {
                ++field.RoundCount;
                ++field.BattleCount;
                ++this._totalRoundCount;
                ++this._totalBattleCount;
                return;
            }
            ++count;
        }
        CounterStatField newField = new CounterStatField();
        newField.FieldName = fieldname;
        newField.RoundCount = 1L;
        newField.BattleCount = 1L;
        this._fields.add(newField);
        ++this._totalRoundCount;
        ++this._totalBattleCount;
    }

    public String GetStatName() {
        return this._counterName;
    }

    private class CounterStatField {
        public String FieldName = null;
        public long RoundCount = 0L;
        public long BattleCount = 0L;

        private CounterStatField() {
        }
    }
}

