/*
 * Decompiled with CFR 0.152.
 */
package rdt.Utils;

import java.awt.geom.Point2D;
import rdt.AgentSmith.AgentSmith;

public class RuleUtils {
    public static double GetWallDistance(double x, double y, double battleWidth, double battleHeight) {
        return Math.min(Math.min(x, battleWidth - x), Math.min(y, battleHeight - y));
    }

    public static boolean IsOutsideBattlefield(Point2D.Double loc, double padding, double battleWidth, double battleHeight) {
        if (loc.getX() < padding) {
            return true;
        }
        if (loc.getY() < padding) {
            return true;
        }
        if (loc.getX() > battleWidth - padding) {
            return true;
        }
        return loc.getY() > battleHeight - padding;
    }

    public static boolean IsOutsideBattlefield(double x, double y, double padding, double battleWidth, double battleHeight) {
        if (x < padding) {
            return true;
        }
        if (y < padding) {
            return true;
        }
        if (x > battleWidth - padding) {
            return true;
        }
        return y > battleHeight - padding;
    }

    public static double GetDistanceToWall(double sourceX, double sourceY, double directionX, double directionY) {
        double distance = 0.0;
        boolean outsideOfBattlefield = false;
        double x = sourceX;
        double y = sourceY;
        double dLength = Math.sqrt(directionX * directionX + directionY * directionY);
        dLength *= 10.0;
        directionX *= 10.0;
        directionY *= 10.0;
        double battlefieldWidth = AgentSmith.Instance().getBattleFieldWidth();
        double battlefieldHeight = AgentSmith.Instance().getBattleFieldHeight();
        while (!outsideOfBattlefield) {
            outsideOfBattlefield = RuleUtils.IsOutsideBattlefield(x, y, 0.0, battlefieldWidth, battlefieldHeight);
            x += directionX;
            y += directionY;
            distance += dLength;
        }
        return distance;
    }
}

