/*
 * Created on 2004-10-14
 */
package tide.util;

import java.awt.geom.Point2D;

/**
 * A bullet.
 * @author xiemin
 */
public class Bullet
{
	private long fireTime;
	private double heading;
	private double power;
	private Point2D fireLocation = new Point2D.Double();
	
	/**
	 * create a new Bullet.
	 */
	public Bullet(){}
	
	/**
	 * create a new Bullet.
	 */
	public Bullet(Point2D fireLocation, long fireTime, double heading, double power)
	{
		setFireLocation(fireLocation);
		setFireTime(fireTime);
		setHeading(heading);
		setPower(power);
	}
	
	/**
	 * Returns the heading of this bullet.
	 * @return the heading of this bullet.
	 */
	public double getHeading()
	{
		return heading;
	}
	
	/**
	 * Return the current location of the bulllet.
	 * @return
	 */
	public Point2D getLocation(double time)
	{
		double d = (time - fireTime)*Utils.bulletVelocity(power);
		return MathUtils.nextPoint(fireLocation, heading, d);
	}
	
	/**
	 * set the fire location of this bullet
	 * @param p fire location
	 */
	public void setFireLocation(Point2D p)
	{
		fireLocation.setLocation(p);
	}
	/**
	 * Returns the fire location of this bullet.
	 * @return the fire location of this bullet.
	 * @return
	 */
	public Point2D getFireLocation()
	{
		return fireLocation;
	}
	/**
	 * Returns the power of this bullet.
	 * @return the power of this bullet.
	 */
	public double getPower()
	{
		return power;
	}

	/**
	 * Set the heading of this bullet.
	 * @param the heading to set.
	 */
	public void setHeading(double heading)
	{
		this.heading = heading;
	}
	
	/**
	 * Set the power of this bullet.
	 * @param power The power to set.
	 */
	public void setPower(double power)
	{
		this.power = power;
	}
	/**
	 * Returns the fire time of this bullet.
	 * @return Returns the fire time.
	 */
	public long getFireTime()
	{
		return fireTime;
	}
	
	/**
	 * Set the fire time of this bullet.
	 * @param fireTime The time to set.
	 */
	public void setFireTime(long fireTime)
	{
		this.fireTime = fireTime;
	}
}
