package tobe.guns;
import tobe.util.*;
import tobe.statistics.*;
import tobe.platform.*;
import robocode.*;

public class HeatMirror implements Gun
{
	/**
	 * May be called several times for the same shot.
	 * Generally will be called once each frame until gun is in position.
	 * Should preferably return adjustments for "the same aim" until
	 * reset is called.
	 */
	public Aim aim(CommandCentre cc) {
		TargetStatistics target = cc.getPreferredTarget();
		if(target == null) return null;
		AdvancedRobot bot = cc.getBot();
			double shotPower = Math.min(3,bot.getEnergy()-5.0);
			if(shotPower < 0.5) shotPower = Math.min(0.5, bot.getEnergy()-0.1);
	/*testing*/		shotPower = (target.getDistance(bot.getX(), bot.getY()) < 500 ? shotPower : Math.min(0.1, shotPower));
		double timeToHit = target.getDistance(bot.getX(), bot.getY())/(20-3*shotPower);
		CircularArray evasions = target.getEvasions();
		BearingVector v = new BearingVector();
		v.setOrigin(target.getX(), target.getY());
		int num = 0;
		for(int j = 1; j < 11 && j <= evasions.size(); j++) {
			Evasion e = (Evasion) evasions.get(-j);
			v.add(e.getHeadingRelativeHeading(), e.getVelocity()*timeToHit);
			num++;
		}
		if(num != 0) v.setDistance(v.getDistance()/(-num));
		v.setBearing(v.getBearing() + target.getHeading());
		v.changeOrigin(bot.getX(), bot.getY());
			double m = bot.getWidth()*0.8;
			double h = cc.getPlayingField().getHeight();
			double w = cc.getPlayingField().getWidth();
			double x = Math.min(w-m,Math.max(m,v.getToX()));
			double y = Math.min(h-m,Math.max(m,v.getToY()));
			v.setPoints(x,y,bot.getX(), bot.getY());
			return new Aim(v.getBearing(), Math.atan(bot.getWidth()/2/v.getDistance()), shotPower);
	}
	
	/**
	 * Will be called when a new shot is to be taken
	 */
	public void reset() {}
}
