package lucasslf.radar;

import lucasslf.WaveSurferBot;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.ScannedRobotEvent;

public abstract class Radar {

	private WaveSurferBot robot;

	public Radar(WaveSurferBot robot) {
		this.robot = robot;
	}

	public abstract void doRun();
	
	public abstract void onHitRobot(HitRobotEvent e2);

	public abstract void onBulletHitBullet(BulletHitBulletEvent e);

	public abstract void onBulletHit(BulletHitEvent e);

	public abstract void onHitByBullet(HitByBulletEvent e);

	public abstract void onScannedRobot(ScannedRobotEvent e);

	public WaveSurferBot getRobot() {
		return robot;
	}

}
