package lucasslf.wavesurfing;

import java.awt.Graphics2D;

import lucasslf.WaveSurferBot;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.CustomEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.ScannedRobotEvent;

public abstract class WaveSurferMovement {


	private WaveSurferBot robot;

	public WaveSurferMovement(WaveSurferBot robot) {
		this.robot = robot;
	}
	
	public abstract void onHitRobot(HitRobotEvent e2);

	public abstract void onBulletHitBullet(BulletHitBulletEvent e);

	public abstract void onBulletHit(BulletHitEvent e);

	public abstract void onHitByBullet(HitByBulletEvent e);

	public abstract void onScannedRobot(ScannedRobotEvent e);

	public abstract void doSurfing();

	public abstract void onPaint(Graphics2D g);

	public abstract void onCustomEvent(CustomEvent e);

	public WaveSurferBot getRobot() {
		return robot;
	}
	
}