package stelo;
import robocode.*;
import robocode.util.Utils;
import java.awt.geom.*;

public class MirrorMovement {
    static final double MAX_VELOCITY = 8;
    static final double WALL_MARGIN = 25;
	Point2D robotLocation;
    Point2D enemyLocation;
    double enemyDistance;
    double enemyAbsoluteBearing;
	AdvancedRobot bot;
	double centerX, centerY;
		
	public MirrorMovement(AdvancedRobot bot) {
		this.bot = bot;
		centerX = bot.getBattleFieldWidth() / 2.0;
		centerY = bot.getBattleFieldHeight() / 2.0;		
	}
	public void initRound() {
		enemyLocation = null;
	}
	
	public void cleanUpRound() {
		enemyLocation = null;
	}

    public void update(ScannedRobotEvent e) {
        robotLocation = new Point2D.Double(bot.getX(), bot.getY());
        enemyAbsoluteBearing = bot.getHeadingRadians() + e.getBearingRadians();
        enemyDistance = e.getDistance();
        enemyLocation = vectorToLocation(enemyAbsoluteBearing, enemyDistance, robotLocation);
    }

    // Always try to move a bit further away from the enemy.
    // Only when the walls forces us we will close in on the enemy. We never bounce of walls.
    public void execute() {
		if (enemyLocation == null) {
			bot.setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
			return;
		}
		Point2D robotDestination = new Point2D.Double();
		
		if (bot.getOthers() == 1)
			robotDestination.setLocation(2.0 * centerX - enemyLocation.getX(), 2.0 * centerY - enemyLocation.getY());
		else
			robotDestination.setLocation(3.0 * centerX - 2.0 * enemyLocation.getX(), 3.0 * centerY - 2.0 * enemyLocation.getY());
					
		goTo(robotDestination);
		
		bot.setTurnRadarRightRadians(Utils.normalRelativeAngle(enemyAbsoluteBearing - bot.getRadarHeadingRadians()) * 2);
    }

	public void radarOnly() {
		if (enemyLocation == null) bot.setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
		else bot.setTurnRadarRightRadians(Utils.normalRelativeAngle(enemyAbsoluteBearing - bot.getRadarHeadingRadians()) * 2);
    }

    void goTo(Point2D destination) {
		// anti-wall
		destination.setLocation(limit(25.0, destination.getX(), bot.getBattleFieldWidth() - 25.0), limit(25.0, destination.getY(), bot.getBattleFieldHeight() - 25.0));
		
        double angle = Utils.normalRelativeAngle(absoluteBearing(robotLocation, destination) - bot.getHeadingRadians());
		double turnAngle = Math.atan(Math.tan(angle));
        bot.setTurnRightRadians(turnAngle);
		//bot.setTurnRightRadians(turnAngle + Math.sin(bot.getTime()) * bot.getVelocity() / 8.0);
        
        bot.setAhead(robotLocation.distance(destination) * (angle == turnAngle ? 1 : -1));
		// Hit the brake pedal hard if we need to turn sharply
		bot.setMaxVelocity(Math.abs(bot.getTurnRemaining()) > 33 ? 0.1 : MAX_VELOCITY);
    }

    static Point2D vectorToLocation(double angle, double length, Point2D sourceLocation) {
		return vectorToLocation(angle, length, sourceLocation, new Point2D.Double());
    }

    static Point2D vectorToLocation(double angle, double length, Point2D sourceLocation, Point2D targetLocation) {
        targetLocation.setLocation(sourceLocation.getX() + Math.sin(angle) * length,
            sourceLocation.getY() + Math.cos(angle) * length);
		return targetLocation;
    }

    static double absoluteBearing(Point2D source, Point2D target) {
        return Math.atan2(target.getX() - source.getX(), target.getY() - source.getY());
    }

    public static double limit(double min, double value, double max) {
        return Math.max(min, Math.min(value, max));
    }
}
