package stelo;

import robocode.*;
import robocode.util.Utils;
import java.awt.geom.*;

public class RandomMovement {
    static double MAX_VELOCITY = 8;
    static final double WALL_MARGIN = 25;
	AdvancedRobot bot;
    Point2D robotLocation;
    Point2D enemyLocation;
    double enemyDistance;
    double enemyAbsoluteBearing;
    double movementLateralAngle = 0.2;
	static double awayFactor = 1.1;

	public RandomMovement(AdvancedRobot bot) {
		this.bot = bot;
	}
	public void initRound() {
		enemyLocation = null;
	}
	
	public void cleanUpRound() {
		enemyLocation = null;
	}

    public void update(ScannedRobotEvent e) {
        robotLocation = new Point2D.Double(bot.getX(), bot.getY());
        enemyAbsoluteBearing = bot.getHeadingRadians() + e.getBearingRadians();
        enemyDistance = e.getDistance();
        enemyLocation = vectorToLocation(enemyAbsoluteBearing, enemyDistance, robotLocation);
    }

    // Always try to move a bit further away from the enemy.
    // Only when the walls forces us we will close in on the enemy. We never bounce of walls.
    public void execute() {
		if (enemyLocation == null) {
			bot.setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
			return;
		}
		considerChangingDirection();
		Point2D robotDestination = null;
		double tries = 0;
		//double awayFactor = (bot.getOthers() == 1 ? 1.0 : 2.0);
		// double awayFactor = 2.0;
		if (bot.getOthers() > 1)
			awayFactor = 2.0;
		
		do {
			// robotDestination = vectorToLocation(absoluteBearing(enemyLocation, robotLocation) + movementLateralAngle,
			//	    enemyDistance * (1.1 - tries / 100.0), enemyLocation);
			
		    robotDestination = vectorToLocation(absoluteBearing(enemyLocation, robotLocation) + movementLateralAngle,
			    enemyDistance * awayFactor * (1.1 - tries / 100.0), enemyLocation);
		    tries++;
		} while (tries < 100 && !fieldRectangle(WALL_MARGIN).contains(robotDestination));
		goTo(robotDestination);
		bot.setTurnRadarRightRadians(Utils.normalRelativeAngle(enemyAbsoluteBearing - bot.getRadarHeadingRadians()) * 2);
    }

	public void radarOnly() {
		if (enemyLocation == null) bot.setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
		else bot.setTurnRadarRightRadians(Utils.normalRelativeAngle(enemyAbsoluteBearing - bot.getRadarHeadingRadians()) * 2);
    }

    void considerChangingDirection() {
	// Change lateral direction at random
	// Tweak this to go for flat movement
		double flattenerFactor = 0.05;
		if (Math.random() < flattenerFactor) {
		    movementLateralAngle *= -1;
		}
		if (bot.getOthers() > 1)
			MAX_VELOCITY = 8.0;
		//if (Math.random() < 0.05 * 8 * 8 / bot.getVelocity() / bot.getVelocity()) {
		if (Math.random() < 0.1) {	
			MAX_VELOCITY = Math.random() * 6.0 + 2.0;
			//bot.out.println("MAX_VELOCITY = " + MAX_VELOCITY);
		}
		if (Math.random() < 0.05) {
			awayFactor = 0.9 + Math.random() * 0.1;
			//bot.out.println("awayFactor = " + awayFactor);
		}
    }

    RoundRectangle2D fieldRectangle(double margin) {
        return new RoundRectangle2D.Double(margin, margin,
	    bot.getBattleFieldWidth() - margin * 2, bot.getBattleFieldHeight() - margin * 2, 75, 75);
    }

    void goTo(Point2D destination) {
        double angle = Utils.normalRelativeAngle(absoluteBearing(robotLocation, destination) - bot.getHeadingRadians());
		double turnAngle = Math.atan(Math.tan(angle));
        bot.setTurnRightRadians(turnAngle);
		//bot.setTurnRightRadians(turnAngle + Math.sin(bot.getTime()) * bot.getVelocity() / 8.0);
        
        bot.setAhead(robotLocation.distance(destination) * (angle == turnAngle ? 1 : -1));
		// Hit the brake pedal hard if we need to turn sharply
		bot.setMaxVelocity(Math.abs(bot.getTurnRemaining()) > 33 ? 0.1 : MAX_VELOCITY);
    }

    static Point2D vectorToLocation(double angle, double length, Point2D sourceLocation) {
		return vectorToLocation(angle, length, sourceLocation, new Point2D.Double());
    }

    static Point2D vectorToLocation(double angle, double length, Point2D sourceLocation, Point2D targetLocation) {
        targetLocation.setLocation(sourceLocation.getX() + Math.sin(angle) * length,
            sourceLocation.getY() + Math.cos(angle) * length);
		return targetLocation;
    }

    static double absoluteBearing(Point2D source, Point2D target) {
        return Math.atan2(target.getX() - source.getX(), target.getY() - source.getY());
    }
}
