package xander.cat;

import java.awt.Color;

import xander.cat.group.shield.BulletShieldingFactory;
import xander.cat.radar.BasicRadar;
import xander.core.AbstractXanderRobot;
import xander.core.ComponentChain;
import xander.core.Configuration;
import xander.core.RobotStyle;

/**
 * Bullet Shielding Robocode robot built on the Xander Framework. 
 * 
 * @author Scott Arnold
 */
public class Spitfire extends AbstractXanderRobot {

	@Override
	protected void style(RobotStyle robotStyle) {
		robotStyle.setColors(Color.YELLOW, Color.WHITE, Color.YELLOW);
	}

	@Override
	protected void configure(Configuration configuration) {
		configuration.setAutoFireOnDisabledOpponents(false);
	}

	@Override
	protected void addComponents(ComponentChain componentChain) {
		//XanderPaintManager.getInstance(this).enable(getBattleFieldHeight()); 
		componentChain.addDefaultComponents(new BasicRadar(45, 3));
		BulletShieldingFactory.addBulletShieldingComponentsAsDefault(componentChain, 1.5, true);
	}
}
