package whind;

import java.awt.geom.*;
import robocode.util.Utils;
import robocode.*;
import java.util.*;

/**
 * LaserBullet - a class by Greywhind
 */
public class LaserBullet
{
	double startx;
	double starty;
	double bearing;
	double power;
	double speed;
	long fireTime;
	int eDirection;
	Vector returnSegment;
	
	public LaserBullet(double sX, double sY, double b, double p, long fTime, int eDir, Vector segment) {
		startx = sX;
		starty = sY;
		bearing = b;
		power = p;
		speed = 20-power*3;
		fireTime = fTime;
		eDirection = eDir;
		returnSegment = segment;
	}
	
	public boolean checkHit(double enemyX, double enemyY, long currentTime) {
		if (Point2D.distance(startx, starty, enemyX, enemyY) <= (currentTime-fireTime)*speed) {
			double desiredDirection = Math.atan2(enemyX-startx, enemyY-starty);
            double angleOffset = Utils.normalRelativeAngle(desiredDirection-bearing);
			returnSegment.add(new Double(angleOffset * eDirection));
			if (returnSegment.size() > 1000) {
				returnSegment.remove(0);
			}
			return true;
		}
		return false;
	}
}
