//ADinosaur
package joe;
import robocode.*;
import java.awt.Color;
import java.awt.geom.Point2D;
import robocode.util.Utils;

/**
 * ADinosaur - a robot by (your name here)
 */
public class ADinosaur extends AdvancedRobot
{
    double dir = 1;
int hitcount = 0;
double hitchange = 1;
    /**
     * run: ADinosaur's default behavior
     */
    public void run() {
setColors(Color.black,Color.black,Color.red);
        while(true) {
setAdjustGunForRobotTurn(true);
setAdjustRadarForGunTurn(true);
            turnRadarRight(360);
        }
    }

/**
     * onScannedRobot:  We have a target.  Go get it.
     */
    public void onScannedRobot(ScannedRobotEvent e) {
        setTurnRight(e.getBearing()+90-20*dir);
if(getDistanceRemaining() == 0){
dir = -dir;
double moveAmount = 60;
if(hitcount > 2){
	hitcount = 0;
	moveAmount += 200*hitchange;
	hitchange = -hitchange;
}
setAhead(moveAmount * dir);
}
        //This code goes in your onScannedRobot() event handler
		
		double bulletPower = Math.min(3.0,getEnergy());
		double myX = getX();
		double myY = getY();
		double absoluteBearing = getHeadingRadians() + e.getBearingRadians();
		double enemyX = getX() + e.getDistance() * Math.sin(absoluteBearing);
		double enemyY = getY() + e.getDistance() * Math.cos(absoluteBearing);
		double enemyHeading = e.getHeadingRadians();
		double enemyVelocity = e.getVelocity();
		
		
		double deltaTime = 0;
		double battleFieldHeight = getBattleFieldHeight(), battleFieldWidth = getBattleFieldWidth();
		double predictedX = enemyX, predictedY = enemyY;
		while((++deltaTime) * (20.0 - 3.0 * bulletPower) < Point2D.Double.distance(myX, myY, predictedX, predictedY)){		
			predictedX += Math.sin(enemyHeading) * enemyVelocity;	
			predictedY += Math.cos(enemyHeading) * enemyVelocity;
			if(	predictedX < 18.0 
				|| predictedY < 18.0
				|| predictedX > battleFieldWidth - 18.0
				|| predictedY > battleFieldHeight - 18.0){
				predictedX = Math.min(Math.max(18.0, predictedX), battleFieldWidth - 18.0);	
				predictedY = Math.min(Math.max(18.0, predictedY), battleFieldHeight - 18.0);
				break;
			}
		}
		double theta = Utils.normalAbsoluteAngle(Math.atan2(predictedX - getX(), predictedY - getY()));
		
		setTurnRadarRightRadians(Utils.normalRelativeAngle(absoluteBearing - getRadarHeadingRadians()));
		setTurnGunRightRadians(Utils.normalRelativeAngle(theta - getGunHeadingRadians()));
		fire(bulletPower);


    }
    public void onHitRobot(HitRobotEvent e) {
        dir*=-1;}

 public void onHitWall(HitWallEvent e) {
        dir*=-1;}
    /**
     * onHitByBullet: What to do when you're hit by a bullet
     */
    public void onHitByBullet(HitByBulletEvent e) {
        dir*=-1;
hitcount++;
    }
        // Helper function
    public double normalRelativeAngle(double angle) {
        if (angle > -180 && angle <= 180)
            return angle;
        double fixedAngle = angle;
        while (fixedAngle <= -180)
            fixedAngle += 360;
        while (fixedAngle > 180)
            fixedAngle -= 360;
        return fixedAngle;
    }
    
}
