package kvk.Utils;
import java.awt.geom.Point2D;
import java.awt.geom.Point2D.Double;

/**
 *  Point : dfinition d'un point (x,y)
 *
 * @author     Ssin.le.Terrible
 * @created    11 septembre 2003
 */
public class Point extends Point2D.Double {

	/**
	 *  Constructor for the Point object
	 *
	 * @param  x  Description of the Parameter
	 * @param  y  Description of the Parameter
	 */
	public Point(double x, double y) {
		super(x, y);
	}

	/**
	 *  Constructor for the Point object
	 *
	 * @param  p  Description of the Parameter
	 */
	public Point(Point p) {
		super(p.getX(), p.getY());
	}

	/**
	 *  Constructor for the Point object
	 */
	public Point() {
		super(0d, 0d);
	}

	// ***************************** METHODES D'ACCES ***************************** //
	public void setX(double valeur) {
		x = valeur;
	}

	public void setY(double valeur) {
		y = valeur;
	}

	public void setXY(double px, double py) {
		x = px;
		y = py;
	}

	public void setXY(Point p) {
		x = p.getX();
		y = p.getY();
	}

	public double getX() {
		return x;
	}

	public double getY() {
		return y;
	}

	public double getAngle() {
		return Fct.arcTan(x, y);
	}

	public double getNorme() {
		return this.distance(0.0, 0.0);
	}

	public boolean isOnField() {
		//return (x > 0d && y > 0d && x < BattleField.getWidth() && y < BattleField.getHeight());
		return BattleField.getBattleField().contains(this);
	}

	public boolean isOnSmallField() {
		//return (x > BattleField.getMinX() && y > BattleField.getMinY() && x < BattleField.getMaxX() && y < BattleField.getMaxY());
		return BattleField.getSmallBattleField().contains(this);
	}

	public boolean isOnSmallRoundedField() {
		return BattleField.getSmallRoundedBattleField().contains(this);
	}

	public boolean isOffField() {
		return !isOnField();
	}
	// ***************************** METHODES D'ACCES ***************************** //

	/**
	 *  Ajoute un point (x,y)
	 *
	 * @param  valX  Description of the Parameter
	 * @param  valY  Description of the Parameter
	 */
	public void plus(double valX, double valY) {
		x += valX;
		y += valY;
	}

	public void plus(Point p) {
		x += p.getX();
		y += p.getY();
	}

	/**
	 *  Soustrait un point (x,y)
	 *
	 * @param  valX  Description of the Parameter
	 * @param  valY  Description of the Parameter
	 */
	public void minus(double valX, double valY) {
		x -= valX;
		y -= valY;
	}

	public void minus(Point p) {
		x -= p.getX();
		y -= p.getY();
	}

	/**
	 *  Description of the Method
	 *
	 * @param  p          Description of the Parameter
	 * @param  tolerance  Description of the Parameter
	 * @return            Description of the Return Value
	 */
	public boolean equals(Point p, double tolerance) {
		return (this.distance(p) <= tolerance);
	}

	/**
	 *  Multiplie par une valeur
	 *
	 * @param  valeur  Description of the Parameter
	 */
	public void mult(double valeur) {
		x *= valeur;
		y *= valeur;
	}

	/**
	 * Renvoie une chaine reprsentant le point
	 *
	 * @return    Description of the Return Value
	 */
	public String toString() {
		return "(" + Fct.round2(x) + "," + Fct.round2(y) + ")";
	}
}

