package kc.nano;
import robocode.util.Utils;
import robocode.AdvancedRobot;
import robocode.ScannedRobotEvent;
import robocode.HitWallEvent;
import robocode.HitByBulletEvent;

/*
 * Splinter - a robot by Kevin Clark (Kev)
 * StopNGo/Random Movement
 * Linear/Random Targeting.
 * 249 bytes
 */
public class Splinter extends AdvancedRobot {
	static double enemyEnergy;
	static double damageReceived;
	static double moveFactor = 48.0;
	static boolean RandomMovement;
	
	public void run() {
		setAdjustRadarForGunTurn(true);
		do {
			turnRadarLeftRadians(1);
		}while(true);
	}

	public void onScannedRobot(ScannedRobotEvent e) {
		double absoluteBearing = e.getBearingRadians();
		setTurnRightRadians(Math.cos(absoluteBearing) - ((e.getDistance() - 220.0) * moveFactor / 35000.0));
		if(RandomMovement && Math.random() < 0.08) {
			onHitWall(null);
		}
	
		setTurnGunRightRadians(Utils.normalRelativeAngle((absoluteBearing += getHeadingRadians()) - getGunHeadingRadians() + (Math.random() < (e.getDistance() - 955) / -1055 ? e.getVelocity() : 5.0 - (Math.random() * 10.0)) / 13.0 * Math.sin(e.getHeadingRadians() - absoluteBearing)));
	 	setTurnRadarRightRadians(2.0 * Utils.normalRelativeAngle(absoluteBearing - getRadarHeadingRadians()));
		setFire(800.0 / e.getDistance());
		
		if(enemyEnergy > (enemyEnergy = e.getEnergy()) || RandomMovement) {
			setAhead(moveFactor);
		}
	}

	public void onHitWall(HitWallEvent e) {
		moveFactor = -moveFactor;
	}

	public void onHitByBullet(HitByBulletEvent e) {
		if((damageReceived += e.getPower()) > 12 * getRoundNum() && getRoundNum() > 3) {
			RandomMovement = true;
		}
	}
}
