// (C) 2007 Kim, Taegyoon
// AGF: anti-guess-factor

package stelo;

import robocode.*;
import robocode.util.Utils;
import java.awt.geom.*;     // for Point2D's
import java.awt.Color;

public class MatchupMicro extends AdvancedRobot {
    private Point2D.Double _myLocation;     // our bot's location

	private static final int PATTERN_LENGTH = 5000;
	private static final int searchLength = 32; // increasing this will slow down the game
	private static int pattern_size = 0;
	
//	private static int bulletTravelTime = 0;
	private static double[] theLog1 = new double[PATTERN_LENGTH];
	private static double[] theLog2 = new double[PATTERN_LENGTH];
	
	private static int cursor = 0;
	
	private static double lastEnemyEnergy;
	private static double lastEnemyHeading;
			
//	private static int ticksSinceMyFire = 0;
	private static double smallestDiff;
	private static double enemyBulletPower = 0.1;
	private static double energyDrop = 0;
//	private static int ticksSinceDirection = 0;	
	
	private static double moveAmount = 100;
	
    public void run() {
//		setColors(null, Color.BLACK, Color.YELLOW);
		
        setAdjustGunForRobotTurn(true);
        setAdjustRadarForGunTurn(true);
//        setAdjustRadarForRobotTurn(true);

        do {
            // basic mini-radar code
            turnRadarRightRadians(Double.POSITIVE_INFINITY);
        } while (true);
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        _myLocation = new Point2D.Double(getX(), getY());

        double absBearing = e.getBearingRadians() + getHeadingRadians();

//        setTurnRadarRightRadians(Utils.normalRelativeAngle(absBearing - getRadarHeadingRadians()) * 2);
		setTurnRadarLeftRadians(getRadarTurnRemainingRadians());
        setTurnRightRadians(Math.cos(e.getBearingRadians()));
        
		double bulletPower;
		energyDrop = lastEnemyEnergy - e.getEnergy();
		if (energyDrop >= 0.1 && energyDrop <= 3) {
			enemyBulletPower = energyDrop;
//			setMaxVelocity(Math.random() * 20 + 2);
//			if (Math.random() < 0.25)
//				moveAmount = -moveAmount;
		}
		bulletPower = enemyBulletPower;
			
		//bulletPower = limit(0.1, bulletPower, (enemyDistance < 100 || getOthers() > 5 || smallestDiff < 1) ? 3.0 : 2.0);
		//if (smallestDiff == 0) bulletPower = 3;
		if (e.getDistance() < 100) bulletPower = 3; // anti-rambot
//		bulletPower = 3;
		bulletPower = Math.min(bulletPower, e.getEnergy() / 5.0 );
		bulletPower = limit(0.1, bulletPower, 3.0);        

// aim

		if (getGunHeat() / getGunCoolingRate() < 3) do {
			int index;
			//indexVelocity = bestIndex(velocityChange);
			//indexAngle = bestIndex(angleChange);
			//indexVelocity = indexAngle = bestIndex(velocityChange, angleChange);
			index = bestIndex(theLog1, theLog2);

//			if (getGunHeat() == 0) {
//				out.println("matched index: " + index + "\tdiff: " + smallestDiff + "\tsearchLength: " + searchLength);
//				ticksSinceMyFire = 0;
//			}
			
			double eX = e.getDistance() * Math.sin(absBearing);
			double eY = e.getDistance() * Math.cos(absBearing);
			
			double db = 0;
			double ww = e.getHeadingRadians();
			double v = e.getVelocity();
	
			//searchLength = 0;
//			if (v * lastEnemyVelocity <= 0) {
//				searchLength = (int) limit(32, ticksSinceDirection + 10, 128);
//				ticksSinceDirection = 0;
//			}
//			ticksSinceDirection++;
			
//			bulletTravelTime = 0;
			do {
				// db+=11; //11 is the velocity of a fire(3) bullet.
				db += (20.0 - 3.0 * bulletPower); // don't use Rules.getBulletSpeed(bulletPower)
				// ww+=w; // turn w radians for next step
	
//				eX += theLog1[index];
//				eY += theLog2[index];

				eX += v * Math.sin(ww);
				eY += v * Math.cos(ww);				
//				eX = limit(18 - _myLocation.x, eX, 800 - 18 - _myLocation.x);
//				eY = limit(18 - _myLocation.y, eY, 600 - 18 - _myLocation.y);

				v = theLog1[index];
				ww += theLog2[index];
				
				if (index + 1 != cursor) {
					index = (index + 1) % PATTERN_LENGTH;
				}
				
				//searchLength += 1;
//				bulletTravelTime++;
			} while (db < Point2D.distance(0, 0, eX, eY)); // The bullet travelled
															// far enough to hit our
															// target!
			//out.println("searchLength: " + searchLength);
			setTurnGunRightRadians(Math.asin(Math.sin(Math.atan2(eX, eY)
					- getGunHeadingRadians())));
			
			if (getEnergy() > bulletPower)
				setFire(bulletPower);
		} while (false);
		else {
			setTurnGunRightRadians(Utils.normalRelativeAngle( absBearing - getGunHeadingRadians() ) );
		}
//		ticksSinceMyFire++;
		
		//out.println("cursor: " + cursor);
		{
//			theLog1[cursor] = e.getVelocity() * Math.sin(e.getHeadingRadians());
//			theLog2[cursor] = e.getVelocity() * Math.cos(e.getHeadingRadians());
			theLog1[cursor] = e.getVelocity();
			theLog2[cursor] = e.getHeadingRadians() - lastEnemyHeading;
			
			//theLog[cursor][1] = e.getHeadingRadians();
			//theLog[cursor][2] = e.getDistance() / 10000;
			//theLog[cursor][3] = (absBearing - lastEnemyBearing) / 100;
			//theLog[cursor][4] = ticksSinceMyFire / 100;
			
			cursor = (cursor + 1) % PATTERN_LENGTH;
			if (pattern_size < PATTERN_LENGTH)
				pattern_size++;
		}
		lastEnemyEnergy = e.getEnergy();
		lastEnemyHeading = e.getHeadingRadians();
	
// move
		if (Math.random() < 0.04)
			moveAmount = -moveAmount;
		if (!(new Rectangle2D.Double(18, 18, 800-36, 600-36)).contains(Math.sin(absBearing = getHeadingRadians())*moveAmount + getX(),Math.cos(absBearing)*moveAmount + getY()))
		moveAmount = -moveAmount;
		
		setAhead(moveAmount);

//		setTurnRadarRightRadians(Utils.normalRelativeAngle(absBearing - getRadarHeadingRadians()) * 2);
    }

//	public void onSkippedTurn(SkippedTurnEvent e) {
//		out.println("Turn skipped at: " + e.getTime());
//	}

	private int bestIndex(double[] series1, double[] series2) {
		smallestDiff = Double.POSITIVE_INFINITY;

		int result = 0;

		int count = 0, i = (PATTERN_LENGTH + cursor - 1) % PATTERN_LENGTH;
		while (count < PATTERN_LENGTH) {
			double diff = 0;
			for (int j = 0; j < searchLength; j++) {
				int k = (i + j) % PATTERN_LENGTH;
				int searchIndex = (PATTERN_LENGTH + cursor - searchLength + j) % PATTERN_LENGTH;
//				if (k == searchIndex) {
				if (Math.abs(k - searchIndex) < searchLength) {
					diff = Double.POSITIVE_INFINITY;
					break;
				}
				diff += Math.abs(series1[searchIndex] - series1[k]);
				diff += Math.abs(series2[searchIndex] - series2[k]);
			}
//			if (diff < smallestDiff && Math.abs((i + searchLength) % PATTERN_LENGTH - cursor) > bulletTravelTime) {
			if (diff < smallestDiff) {
			//if (diff == 0) {
				smallestDiff = diff;
				result = (i + searchLength) % PATTERN_LENGTH;
			}
			count++;
			i = (PATTERN_LENGTH + i - 1) % PATTERN_LENGTH;
				
		}
		//out.println("Diff: " + smallestDiff);
		return result;				
	}				

    public static double limit(double min, double value, double max) {
        return Math.max(min, Math.min(value, max));
    }
}																																																	