package zyx.mega.utils;

import static zyx.mega.utils.Range.Normalize;
import zyx.mega.bot.Bot;
import zyx.mega.geometry.Geometry;

public class Snapshot {

  public Bot me_;
  public Bot enemy_;
  public double distance_;

  /* Wave Surfing */
  public boolean ws_hit_;
  public double ws_hit_factor_;
  public Range ws_hit_factor_window_;

  public static final int WS_DISTANCE = 0;
  public static final int WS_LATERAL_VELOCITY = 1;
  public static final int WS_ACCELERATION = 2;
  public static final int WS_APPROACHING_VELOCITY = 3;
  public static final int WS_AHEAD_TICKS = 4;
  public static final int WS_BACK_TICKS = 5;
  public static final int WS_ROTATION = 6;
  public static final int WS_VELOCITY = 7;
  public static final int WS_ATTRIBUTES = 8;

  public static final int WS_TIME_DIRECTION = 8;
  public static final int WS_TIME_STOPPED = 9;
  public static final int WS_TIME_RUNNING = 10;
  public static final int WS_BULLET_HIT_TIME = 11;

  /* Guess Factor Targeting */
  //public boolean gf_hit_;
  public static final int SPOT = 0;
  public static final int BOT_HIT = 1;
  public static final int BULLET_HIT = 2;
  public int gf_hit_;
  public double gf_hit_factor_;
  public Range gf_bbox_factor_window_;
  public Range gf_corner_factor_window_;


  public static final int GF_DISTANCE = 0;
  public static final int GF_LATERAL_VELOCITY = 1;
  public static final int GF_ACCELERATION = 2;
  public static final int GF_APPROACHING_VELOCITY = 3;
  public static final int GF_AHEAD_TICKS = 4;
  public static final int GF_BACK_TICKS = 5;
  public static final int GF_ROTATION = 6;
  public static final int GF_VELOCITY = 7;
  public static final int GF_ATTRIBUTES = 8;
  
  public static final int GF_FIRE_POWER = 8;
  public static final int GF_TIME_DIRECTION = 8;
  public static final int GF_TIME_STOPPED = 9;
  public static final int GF_TIME_RUNNING = 10;
  public static final int GF_BULLET_HIT_TIME = 11;
  
  /* Pseudo-PM */
  public static final int PM_DISTANCE = 0;
  public static final int PM_LATERAL_VELOCITY_2AGO_ = 1;
  public static final int PM_APPROACHING_VELOCITY_2AGO_ = 2;
  public static final int PM_LATERAL_VELOCITY_1AGO_ = 3;
  public static final int PM_APPROACHING_VELOCITY_1AGO_ = 4;
  public static final int PM_LATERAL_VELOCITY_NOW_ = 5;
  public static final int PM_APPROACHING_VELOCITY_NOW_ = 6;
  public static final int PM_ATTRIBUTES = 7;
  
  private static final int MAX_TIME_VALUE = 50;
  
  public static final int MAX_WALL_DISTANCE = MAX_TIME_VALUE;
  
  /**
  private static final double MAX_TIME_STOPPED = MAX_TIME_VALUE;
  private static final double MAX_TIME_RUNNING = MAX_TIME_VALUE;
  private static final double MAX_TIME_DIRECTION = MAX_TIME_VALUE;
  /**/

  public double ws_normal_[];
  public double gf_normal_[];
  public double pm_normal_[];
  
  public void NormalizeSnapshot() {
    /* WaveSurfing */
    if ( Config.movement_enabled_ ) {
      ws_normal_ = new double[WS_ATTRIBUTES];
      ws_normal_[WS_DISTANCE] = Normalize(distance_, 0, 800, false);
      ws_normal_[WS_LATERAL_VELOCITY] = Normalize(me_.lateral_velocity_, 0, 8, true);
      ws_normal_[WS_APPROACHING_VELOCITY] = Normalize(me_.approaching_velocity_, -8, 8, false);
      ws_normal_[WS_VELOCITY] = Normalize(me_.velocity_, 0, 8, true);
      ws_normal_[WS_ACCELERATION] = Normalize(me_.acceleration_, -2, 1, false);
      ws_normal_[WS_ROTATION] = Normalize(me_.rotation_, -Geometry.PI_18, Geometry.PI_18, false);
      ws_normal_[WS_AHEAD_TICKS] = Normalize(me_.ahead_ticks_, 1, MAX_WALL_DISTANCE, false);
      ws_normal_[WS_BACK_TICKS] = Normalize(me_.back_ticks_, 1, MAX_WALL_DISTANCE, false);
      //ws_normal_[WS_TIME_STOPPED] = Normalize(me_.time_stopped_, 1, MAX_TIME_STOPPED, false);
      //ws_normal_[WS_TIME_RUNNING] = Normalize(me_.time_running_, 1, MAX_TIME_RUNNING, false);
      //ws_normal_[WS_TIME_DIRECTION] = Normalize(me_.time_direction_, 1, MAX_TIME_DIRECTION, false);
      StringBuilder ws = new StringBuilder();
      for ( int i = 0; i < WS_ATTRIBUTES; ++i ) {
        if ( i > 0 ) ws.append(", "); 
        ws.append(ws_normal_[i]); 
      }
      //System.out.println(ws);
    }
    /* GuessFactoring */
    if ( Config.targeting_enabled_ ) {
      gf_normal_ = new double[GF_ATTRIBUTES];
      gf_normal_[GF_DISTANCE] = Normalize(distance_, 0, 800, false);
      gf_normal_[GF_LATERAL_VELOCITY] = Normalize(enemy_.lateral_velocity_, 0, 8, true);
      gf_normal_[GF_VELOCITY] = Normalize(enemy_.velocity_, 0, 8, true);
      gf_normal_[GF_ACCELERATION] = Normalize(enemy_.acceleration_, -2, 1, false);
      gf_normal_[GF_ROTATION] = Normalize(enemy_.rotation_, -Geometry.PI_18, Geometry.PI_18, false);
      gf_normal_[GF_AHEAD_TICKS] = Normalize(enemy_.ahead_ticks_, 1, MAX_WALL_DISTANCE, false);
      gf_normal_[GF_BACK_TICKS] = Normalize(enemy_.back_ticks_, 1, MAX_WALL_DISTANCE, false);
      gf_normal_[GF_APPROACHING_VELOCITY] = Normalize(enemy_.approaching_velocity_, -8, 8, false);
      //gf_normal_[GF_TIME_STOPPED] = Normalize(enemy_.time_stopped_, 0, MAX_TIME_STOPPED, false);
      //gf_normal_[GF_TIME_RUNNING] = Normalize(enemy_.time_running_, 0, MAX_TIME_RUNNING, false);
      //gf_normal_[GF_TIME_DIRECTION] = Normalize(enemy_.time_direction_, 0, MAX_TIME_DIRECTION, false);
      StringBuilder gf = new StringBuilder();
      for ( int i = 0; i < GF_ATTRIBUTES; ++i ) {
        if ( i > 0 ) gf.append(", "); 
        gf.append(String.format("%.2f", gf_normal_[i])); 
      }
      //System.out.println(gf);
      /*
      pm_normal_ = new double[PM_ATTRIBUTES];
      pm_normal_[PM_DISTANCE] = Normalize(distance_, 0, 800, false);
      pm_normal_[PM_LATERAL_VELOCITY_NOW_] = Normalize(enemy_.lateral_velocity_, 0, 8, true);
      pm_normal_[PM_APPROACHING_VELOCITY_NOW_] = Normalize(enemy_.approaching_velocity_, -8, 8, false);
      pm_normal_[PM_LATERAL_VELOCITY_1AGO_] = Normalize(enemy_.lateral_velocity_1ago_, 0, 8, true);
      pm_normal_[PM_APPROACHING_VELOCITY_1AGO_] = Normalize(enemy_.approaching_velocity_1ago_, -8, 8, false);
      pm_normal_[PM_LATERAL_VELOCITY_2AGO_] = Normalize(enemy_.lateral_velocity_2ago_, 0, 8, true);
      pm_normal_[PM_APPROACHING_VELOCITY_2AGO_] = Normalize(enemy_.approaching_velocity_2ago_, -8, 8, false);
      StringBuilder pm = new StringBuilder();
      pm.append(String.format("%.2f %.2f %.2f %.2f %.2f %.2f %.2f\n", distance_,
          enemy_.lateral_velocity_,
          enemy_.approaching_velocity_,
          enemy_.lateral_velocity_1ago_,
          enemy_.approaching_velocity_1ago_,
          enemy_.lateral_velocity_2ago_,
          enemy_.approaching_velocity_2ago_));
      for ( int i = 0; i < PM_ATTRIBUTES; ++i ) {
        if ( i > 0 ) pm.append(", "); 
        pm.append(String.format("%.2f", pm_normal_[i])); 
      }
      //System.out.println(pm);
      */
    }
  }
}
