package tobe.platform;

/**
 * Must be implemented by a gun (= an aiming algorithm)
 */
public interface Gun
{
	/**
	 * May be called several times for the same shot.
	 * Generally will be called once each frame until gun is in position.
	 * Should preferably return adjustments for "the same aim" until
	 * reset is called.
	 */
	public Aim aim(CommandCentre cc);
	
	/**
	 * Will be called when a new shot is to be taken
	 */
	public void reset();
}
