package simonton.guns;

import java.awt.geom.Point2D;

import robocode.ScannedRobotEvent;
import robocode.util.Utils;
import simonton.utils.Util;

public class InBoundLinearGun extends Gun {

	@Override
	public void onScannedRobot(ScannedRobotEvent e) {
		double bulletPower = getNextBulletPower();
		double myX = getX();
		double myY = getY();
		double absoluteBearing = getHeadingRadians() + e.getBearingRadians();
		double enemyX = getX() + e.getDistance() * Math.sin(absoluteBearing);
		double enemyY = getY() + e.getDistance() * Math.cos(absoluteBearing);
		double enemyHeading = e.getHeadingRadians();
		double enemyVelocity = e.getVelocity();
		
		
		double deltaTime = 0;
		double battleFieldHeight = Util.worldHeight, battleFieldWidth = Util.worldWidth;
		double predictedX = enemyX, predictedY = enemyY;
		while((++deltaTime) * (20.0 - 3.0 * bulletPower) < Point2D.Double.distance(myX, myY, predictedX, predictedY)){		
			predictedX += Math.sin(enemyHeading) * enemyVelocity;	
			predictedY += Math.cos(enemyHeading) * enemyVelocity;
			if(	predictedX < 18.0 
				|| predictedY < 18.0
				|| predictedX > battleFieldWidth - 18.0
				|| predictedY > battleFieldHeight - 18.0){
				
				predictedX = Math.min(Math.max(18.0, predictedX), battleFieldWidth - 18.0);	
				predictedY = Math.min(Math.max(18.0, predictedY), battleFieldHeight - 18.0);
				break;
			}
		}
		double theta = Utils.normalAbsoluteAngle(Math.atan2(predictedX - getX(), predictedY - getY()));
		
		setTurnGunRightRadians(Utils.normalRelativeAngle(theta - getGunHeadingRadians()));
	}
}
