package hamilton;

import robocode.*;
import java.util.*;

public class TargetManager 
{
	AdvancedRobot r;
	
	boolean hasTarget;
	
	HashMap targetMap;
	int targetsScanned = 0;
	
	HashSet enemyBullets;
	
	Statistic reactionAverage;
	
	public TargetManager(AdvancedRobot someR)
	{
		r = someR;
		
		hasTarget = false;
		targetMap = new HashMap();
		
		enemyBullets = new HashSet();
		
		reactionAverage = new Statistic();
	}
		
	public void updateTarget(ScannedRobotEvent e)
	{	
		Coordinate robotCoordinates = new Coordinate (r.getX(), r.getY());
		
		double absoluteBearing = Calculator.normalizeAngle(e.getBearingRadians() + r.getHeadingRadians());
		double distance = e.getDistance();
		
		Coordinate targetCoordinates = robotCoordinates.getCoordinates(absoluteBearing, distance);
			
		ScanInfo scan = new ScanInfo(targetCoordinates, e.getEnergy(), e.getVelocity(), e.getHeadingRadians(), e.getTime());
		
		if (!targetMap.containsKey(e.getName()))
		{			
			targetMap.put( e.getName(), new Target(e.getName(), r.getDataFile( e.getName()+ ".dat" ), scan) );
			targetsScanned ++;
		}
		
		else
		{
			Target t = (Target)targetMap.get(e.getName());
		
			t.update(scan);
			
			// check here to see if enemy fired
			if ( (t.timeSinceLastScan <= 1) && (t.changeInEnergy >= .1) && (t.changeInEnergy <= 3))
			{
				t.gunHeat = 1 + (t.changeInEnergy / 5);
				// System.out.println("Bullet Fire");
				
				EnemyBullet bullet = new EnemyBullet(r, t, "stationary", r.getTime(), 0, t.changeInEnergy, t.getCoordinates());
			}			
			
		}
	}
	
	public boolean hasTarget()
	{
		return !targetMap.isEmpty();
	}
	
	public int getTargetsScanned()
	{
		return targetsScanned;
	}
	
	public Iterator getTargetIterator()
	{
		Collection c = targetMap.values();
		return c.iterator();
	}
	
	public void removeTarget(String someName)
	{
		Target t = (Target)targetMap.get(someName);
		t.writeMemory();
		targetMap.remove(someName);
	}
	
	public void hamiltonHitTarget(BulletHitEvent e)
	{
		if (targetMap.containsKey(e.getName()))
		{
			Target t = (Target)targetMap.get(e.getName());
			t.hamiltonHitTarget(e.getBullet().getPower());
		}
	}
	
	public void targetHitHamilton(HitByBulletEvent e)
	{
		if (targetMap.containsKey(e.getName()))
		{
			Target t = (Target)targetMap.get(e.getName());
			t.targetHitHamilton(e.getPower());
		}
	}

	public Iterator getEnemyBulletIterator()
	{
		return enemyBullets.iterator();
	}	
	
}

