/*
FoilistNano v3.2 by Sheldor.  10/02/2024  246 bytes
a nanobot with random movement and pattern matching targeting
v3.2 -- targeting, movement, energy management

Foil is one of the three forms of modern sport fencing,
along with épée and sabre.  https://en.wikipedia.org/wiki/Foil_%28fencing%29

Credits:
Thanks go to the authors of the following bots: 
jk.sheldor.nano.Yatagan, kc.micro.WaveShark, jk.micro.Toorkild, jk.micro.Cotillion, and oog.nano.Fuatisha.
Also, a general thanks to all open source bot authors and contributors to the RoboWiki.

FoilistNano is open source and released under the terms of the RoboWiki Public Code License (RWPCL) - Version 1.1.
See license here: http://robowiki.net/wiki/RWPCL
*/

package sheldor.nano;

import robocode.*;
import robocode.util.Utils;
import java.lang.Math;

public class FoilistNano extends AdvancedRobot
{
	//constants
	static final int BULLET_POWER = 2;
	
	//global variables
	static double direction = Double.POSITIVE_INFINITY;
	
	public void onStatus(StatusEvent e)
	{		
		//set the radar and gun to turn independently
		//Putting these here with the radar code lets me get rid of the run() method, saving one byte.  credit to Cotillion
		setAdjustRadarForGunTurn(true);		
		setAdjustGunForRobotTurn(true);

		//turn the radar every tick
		//Putting the code here instead of in a while(true) loop in the run() method saves one byte.
		//I believe Wompi discovered this.
		setTurnRadarRightRadians(1);
	}	

	public void onScannedRobot(ScannedRobotEvent e) 
	{		
		//local variables
		int distance;
       double absoluteBearing;
		int integer = 40;
       int matchPosition;	
		
		//distancing based on Yatagan's
		setTurnRightRadians(Math.cos((absoluteBearing = e.getBearingRadians())
			+ (235 - (distance = (int)e.getDistance())) * (getVelocity() / 2000)));
		
		//pattern matching based on Yatagan's
		//Record the current enemy lateral velocity.
		enemyHistory = String.valueOf(
			(char)((int)Math.round((e.getVelocity() * Math.sin(e.getHeadingRadians()
				 - (absoluteBearing += getHeadingRadians())) / 2)))).concat(enemyHistory);
		  
		//radar
		setTurnRadarRightRadians(Utils.normalRelativeAngle(absoluteBearing - getRadarHeadingRadians()));

        //Find the longest match allowable in the enemy history.
        do{}while((matchPosition = enemyHistory.indexOf(enemyHistory.substring(0, --integer), 64)) < 0);			
		
		//energy management based on distance and enemy energy
		setFire(Math.min((127 / distance) + BULLET_POWER, e.getEnergy() / 4));

		//random movement inspired by Yatagan
		setAhead(direction *= (Math.random() - 0.0925));
		
		//Assume that the enemy will repeat their movements in the ticks following the recording of the original pattern.
		//Generate a firing angle based on that assumption.
		do
		{
			//Go through the log of enemy movements right after the original pattern was recorded.
			//Add the angular velocities directly to the absoluteBearing variable.
        	absoluteBearing += (((short) enemyHistory.charAt(--matchPosition)) << 1) /  e.getDistance();
        }		
		while ((distance -= 14) > 0); //Keep projecting the enemy's movement forward until our bullet would reach their predicted location.
		
		//Aim the gun at the enemy's predicted location.
		setTurnGunRightRadians(Utils.normalRelativeAngle(absoluteBearing - getGunHeadingRadians()));
	}	
	
	public void onHitWall(HitWallEvent e) 
	{
		//Reverse direction when the bot hits a wall.
		direction = -direction;
	}		
	
	//symbolic log of enemy movements for pattern matcher, from Yatagan
	//preloaded to prevent StringIndexOutOfBoundsException
   static String enemyHistory = ""
   + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 
   + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 
   + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 
   + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 
   + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 1 
   + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 
   + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 
   + (char) 1 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 
   + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 
   + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 
   + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 
   + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 
   + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 
   + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 
   + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 
   + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 
   + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 
   + (char) 0 + (char) 0 + (char) 1 + (char) 0 + (char) 0 + (char) 0 
   + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 
   + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 
   + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 
   + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 
   + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 
   + (char) 0 + (char) 0 + (char) 0 + (char) 1 + (char) 0 + (char) 0 
   + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 
   + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 
   + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 
   + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 
   + (char)-1 + (char)-2 + (char)-3 + (char)-4 + (char)-5 + (char)-6 
   + (char)-7 + (char)-8 + (char) 8 + (char) 7 + (char) 6 + (char) 5 
   + (char) 4 + (char) 3 + (char) 2 + (char) 1 + (char) 0 + (char) 0;
}																																																												 																																										