package sgp;
import robocode.*;
import java.util.*;
import java.lang.String;

/**
 * TeamTarget - a class by Simon Parker
 */

public class TeamTarget extends Object implements java.io.Serializable
{
	//this class is a table of targets for use in teams.
//	Drunken robot;
	public String name;
	public Coordinate position = new Coordinate();
	public double velocity = 0;
	public double heading_deg = 0;
	public double energy = 0;
	public double lastTimeScanned = 0;
	public boolean isAlive = true;
	public double angularVelocity = 0;
	private boolean isLeader = false;
	public JiggleAnalyser jiggleAnalyser = null;
	public PatternAnalyser patternAnalyser = null;


	public RobotSnapshot getSnapshot()
	{
		return new RobotSnapshot
		(
			name,
			position,
			velocity,
			heading_deg,
			angularVelocity,
			energy,
			lastTimeScanned
		);
	}

	public void reset()
	{
		isAlive = true;
		lastTimeScanned = -1;
		energy = 100;
		isLeader = false;
		jiggleAnalyser.reset();
		patternAnalyser.reset();
	}

	public boolean isLeader()
	{
		return isLeader;
	}

	public void set(RobotSnapshot robotSnapshot)
	{
//		isAlive = true;
		if (robotSnapshot.scanTime <= lastTimeScanned) return;

		name = robotSnapshot.name;
		position.set(robotSnapshot.position);
		velocity = robotSnapshot.velocity;
		heading_deg = robotSnapshot.heading_deg;
		energy = robotSnapshot.energy;
		lastTimeScanned = robotSnapshot.scanTime;
		angularVelocity = robotSnapshot.angularVelocity;

		isLeader = (!isLeader && (energy > 180)) || isLeader;

		jiggleAnalyser.update(position, velocity, heading_deg);
		patternAnalyser.update(position, velocity, heading_deg, (int)(robotSnapshot.scanTime));

	}

	public TeamTarget(RobotSnapshot snapshot)
	{
		jiggleAnalyser = new JiggleAnalyser(Environment.getRobot());
		patternAnalyser = new PatternAnalyser(Environment.getRobot());
		set(snapshot);
	}

	public TeamTarget(String targetName)
	{
		jiggleAnalyser = new JiggleAnalyser(Environment.getRobot());
		patternAnalyser = new PatternAnalyser(Environment.getRobot());

		name = targetName;
	}

	public boolean isEnemy()
	{

		return !Environment.getTeamRobot().isTeammate(name);
	}


	public Coordinate getEstimatedPosition(double currentTime)
	{
		int dT = (int)(currentTime - lastTimeScanned);
		double dx = velocity * (currentTime - lastTimeScanned) * Math.sin(Math.toRadians(heading_deg));
		double dy = velocity * (currentTime - lastTimeScanned) * Math.cos(Math.toRadians(heading_deg));
//		Environment.getRobot().out.println("v " + velocity + ", dt = " + dT + "(" + (int)dx + "," + (int)dy + ")");
		return new Coordinate(position.x + dx, position.y + dy);
	}

}