package cx.util.iiley;
import java.awt.geom.*;
import robocode.*;
import java.io.*;
import java.util.zip.*;
/**
 * @author iiley
 * the tools methods for counting
 */
public class Util
{
	static final public double doublePI=Math.PI*2.0;
	static final public double halfPI=Math.PI/2.0;
	static final public double quarterPI=Math.PI/4.0;
	static final public double radarMaxTurnRateRadians=45.0/180.0*Math.PI;
	static final public double gunMaxTurnRateRadians=20.0/180.0*Math.PI;
	static final public double maxTurnRateRadians=10.0/180.0*Math.PI;
	static final public double radarMaxTurnRate=45;
	static final public double gunMaxTurnRate=20;
	static final public double maxTurnRate=10;
	static final public double maxVelocity=8;

	static public double distance(double x1,double y1,double x2,double y2){
		return Point2D.distance( x1,y1,x2,y2 );
	}
	static public double increase(double value,double incV){
		if(value>=0){
			return value+incV;
		}else{
			return value-incV;
		}
	}
	static public double clockwiseAngle(double firstDir,double secondDir){
    	double subtraction=Util.standardAngle(firstDir)-Util.standardAngle(secondDir);
	    if(subtraction>Math.PI){
		    return subtraction-=Math.PI*2;
	    }
    	if(subtraction<(-1)*Math.PI){
    		return subtraction+=Math.PI*2;
    	}
    	return subtraction;
    }
	//the dir can only be 0 to Math.PI*2
	static public double standardBotAngle(double dir){
		dir%=Math.PI*2;
		if(dir<0){
			dir+=Math.PI*2;
		}
		return dir;
	}
    static public double rightAngle(double first,double second){
		return Util.standardBotAngle(first-second);
	}
	public static double standardAngle( double ang ) {	//get the relative angle where - PI < angle < PI
		return Math.atan2( Math.sin( ang ), Math.cos( ang ) );
	}
	public static Point2D.Double nextPoint(Point2D.Double originPoint,double angle,double distance){
		return new Point2D.Double(originPoint.x+Math.sin(angle)*distance,originPoint.y+Math.cos(angle)*distance);
	}
	public static double maxmin(double max,double min,double value){
		return Math.min(Math.max(min,value),max);
	}
	public static int maxmin(int max,int min,int value){
		if(value>max) value=max;
		else if(value<min) value=min;
		return value;
	}

	public static double getAngle(Point2D.Double p2,Point2D.Double p1){
		return Math.atan2(p2.x-p1.x,p2.y-p1.y);
	}
	public static double bulletVelocity(double power){
		return 20d-3d*power;
	}

	public static File getStatistFile(String name , AdvancedRobot robot,boolean isSave){
        File    directory       = robot.getDataDirectory();
        File[]  robotFiles      = directory.listFiles();
        String  fileName=getNameWithoutVersion(name);
        File    file            = robot.getDataFile(fileName);
        long totalBytes=0;
		for(int i=0;robotFiles!=null && i<robotFiles.length;i++){
			if(!robotFiles[i].equals(file))
		    	totalBytes+=robotFiles[i].length();
		}
		//robot.out.println("total bytes="+totalBytes);
		if(isSave && totalBytes>190000){
	    	File oldestFile=robotFiles[0];
	    	for(int i=0;i<robotFiles.length;i++){
				if(robotFiles[i].lastModified()<oldestFile.lastModified()){
					oldestFile=robotFiles[i];
				}
	    	}
            try {
				 robot.out.println("I cannot remember so much rivals,i have to forget one : "+oldestFile.getName());
                 RobocodeFileOutputStream out = new RobocodeFileOutputStream(oldestFile);
                 out.close();
                 oldestFile.delete();
            } catch (IOException e) {
				robot.out.println("error when forget : "+e.getMessage());
			}			
		}
		return file;
	}

	public static String getNameWithoutVersion(String name){
		int endIndex=name.indexOf(" ");
		if(endIndex>0){
    		return name.substring(0,endIndex);
		}else{
			return name;
		}
	}
};