package sch;

import robocode.*;
import java.util.*;

public class SimpleStrategy extends Strategy implements Constants {

	private final String strategyName="Simple Strategy";
	private int direction;
	private double timeInterval;
	private double timeCounter;
	private boolean hitSomething=false;
	private double goodness;
	private double radarDirection=1.0;
	
	public SimpleStrategy () {
		super();
		direction=1;
		timeInterval=0;
		timeCounter=0;
	}

	public void reinitialize () {
		hitSomething=false;
		direction=1;
		timeInterval=0;
		timeCounter=0;	
	}
	
	
	public String getName() {return strategyName;}
	
	public void setMovement() {
		double movement;
		double maxSpeed;
		double bearingToTarget;
		double turnAmount=0;
		double diffAngle=0;
		double angleTurningDir=-1;
		String targetName="";		//For debugging purpose
		Bot target=null;
		
		if (hitSomething){
			direction*=-1;
			myBot.setAhead(direction*calculateRandomMovement());
			hitSomething=false;
			timeCounter=0;
		}
		else {
			if (timeCounter>=timeInterval) {
				direction*=-1;
				movement=calculateRandomMovement();
				maxSpeed=calculateRandomSpeed();
				timeInterval=calculateRandomTimeInterval();
				if (BotUtil.varContains(DEBUG,DEBUG_BOT_MOVEMENT)) myBot.out.println("Moving for " + BotMath.round2(movement) +"px at " + BotMath.round2(maxSpeed)+"px/tk for "+ timeInterval +" ticks");
				myBot.setMaxVelocity(maxSpeed);
				myBot.setAhead(direction*movement);
				timeCounter=0;
			}
		}
		target = enemyManager.getCurrentTarget();
		if (BotUtil.varContains(DEBUG,DEBUG_BOT_MOVEMENT)) targetName="none selected";
		if(target!=null) {
			diffAngle=Math.random()*PI/8;
			angleTurningDir*=-1;
			bearingToTarget=BotMath.normaliseBearing(BotMath.absBearing(new Point(myBot.getX(), myBot.getY()), target.getPos())-myBot.getHeadingRadians());
			turnAmount=BotMath.normaliseBearing(bearingToTarget+PI/2-direction*angleTurningDir*diffAngle);
			if (BotUtil.varContains(DEBUG,DEBUG_BOT_MOVEMENT)) targetName=target.getName();
		}
		if (BotUtil.varContains(DEBUG,DEBUG_BOT_MOVEMENT)) myBot.out.println("Turning right for " + BotMath.round2(Math.toDegrees(turnAmount)) + " to stay PI/2 to "+targetName);
		myBot.setTurnRightRadians(turnAmount);
		timeCounter++;
	}

	public void setScan() {
		double maxBearing=0.0;
		double maxBearingAbs=0.0;
		double targetBearing;
		double radarTurnAmount;
		int scannedRobot=0;
		
		if (myBot.getRadarTurnRemaining()==0){
			if (BotUtil.varContains(DEBUG,DEBUG_RADAR_MOVEMENT)) System.out.println("My pos = " + myBot.getX()+", "+ myBot.getY());
			for (Iterator i=enemyManager.getEnemyList().values().iterator();i.hasNext();) {
				Bot currentBot=(Bot) i.next();
				if (currentBot.isUpdated()) {
					targetBearing=BotMath.absBearing(new Point(myBot.getX(), myBot.getY()), currentBot.getPos());
					radarTurnAmount=BotMath.normaliseBearing(targetBearing-myBot.getRadarHeadingRadians());
					if (BotUtil.varContains(DEBUG,DEBUG_RADAR_MOVEMENT)) System.out.println(currentBot.isUpdated() +" "+ currentBot.getLastUpdateTime() +" " + currentBot.getName() + " "+ currentBot.getPos() +" " + Math.toDegrees(targetBearing) + " " + Math.toDegrees(radarTurnAmount));
					if (Math.abs(radarTurnAmount)>maxBearingAbs){
						maxBearing=radarTurnAmount;
						maxBearingAbs=Math.abs(radarTurnAmount);
					}
					scannedRobot++;
				}	
			}
			if(scannedRobot==myBot.getOthers()){
				radarDirection=BotMath.sign(maxBearing);
				myBot.setTurnRadarRightRadians(maxBearing+radarDirection*0.35);
			}
			else
				myBot.setTurnRadarRightRadians(radarDirection*PI);
			if (BotUtil.varContains(DEBUG,DEBUG_RADAR_MOVEMENT)) System.out.println("Turning radar for " + Math.toDegrees(maxBearing+BotMath.sign(maxBearing)*0.35) );
		}
	}
	
	public double getGoodness() {return 0.0;}
	
	public void setGunRotation() {
		Point myPosition;
		double gunTurnAmount;
		double firePower;
		Point estimatedPosition;
		double targetBearing;
		double angleThreshold;
		double estamatedDistance;
		Bot target;
		
		target = enemyManager.getCurrentTarget();
		myPosition=new Point(myBot.getX(), myBot.getY());
		
		if (target!=null) {
			estimatedPosition=target.guessInterceptPosition(myPosition,1,myBot.getTime());
			estamatedDistance=BotMath.getRange(estimatedPosition,myPosition);
			targetBearing=BotMath.absBearing(new Point(myBot.getX(), myBot.getY()), estimatedPosition);
			gunTurnAmount=BotMath.normaliseBearing(targetBearing-myBot.getGunHeadingRadians());
			angleThreshold=Math.atan(TARGET_RADIUS/estamatedDistance);
			if (BotUtil.varContains(DEBUG,DEBUG_GUN_MOVEMENT)) System.out.println("Moving gun to " + Math.toDegrees(gunTurnAmount) + " to aim " + target.getName());
			myBot.setTurnGunRightRadians(gunTurnAmount);
			firePower=target.calcFirePower(estamatedDistance);
			if (firePower!=0.0 && Math.abs(gunTurnAmount)<=angleThreshold && myBot.getGunHeat()==0 && !BotUtil.isOutOfBattleFieldBounds(myBot,estimatedPosition)) {
				if (BotUtil.varContains(DEBUG,DEBUG_FIREING)) System.out.println("Firing at " + target.getName()+" - "+ BotMath.round2(estamatedDistance));
				Bullet shotBullet=myBot.fireBullet(firePower);
				target.addShot(shotBullet);
			}
		}
	}

	public void onHitWall(HitWallEvent e) {
    	hitSomething=true;
    	if (BotUtil.varContains(DEBUG,DEBUG_EVENT_NOTIFICATION)) System.out.println("Hit Wall: Moving backward");
   }

	public void onHitRobot(HitRobotEvent  e) {
    	hitSomething=true;
    	if (BotUtil.varContains(DEBUG,DEBUG_EVENT_NOTIFICATION)) System.out.println("Hit another robot: Moving backward");
	}
}