/*
 * Copyright (c) 2004 Marcin Fuszara
 */  
package fushi.PvP1;

// a 2d vector + basic operations
public class Vector2d
{
	public double x;   // these are vector values
	public double y;
	
	/* constructors
	 */
	
	public Vector2d()
	{
	   set( 0, 0 );
	}
	
	public Vector2d( double x, double y )
	{
	   set( x, y );
	}
	
	public Vector2d( Vector2d vector )
	{
	   set( vector );
	}
	
	// set this vector to given values
	public void set( double x, double y )
	{
		this.x = x;
		this.y = y;
	}
	
	// copy the vector from another one
	public void set( Vector2d v )
	{
		this.x = v.x;
		this.y = v.y;
	}
	
	// set vector from angle [radians] from OX axis and distance from (0,0)
	public void setFromAngleDistance( double radians, double distance )
	{
		x = distance * Math.sin( radians );
		y = distance * Math.cos( radians );
	}
	
	// add another vector to this one
	public void add( Vector2d v )
	{
		x += v.x;
		y += v.y;
	}
	
	// subtract another vector from this one
	public void sub( Vector2d v )
	{
		x -= v.x;
		y -= v.y;
	}
	
	// multiply vector by scalar
	public void mul( double s )
	{
		x *= s;
		y *= s;
	}
	
	// divide vector by scalar
	public void div( double s )
	{
		x /= s;
		y /= s;
	}
	
	// calculate and return dot product with another vector
	public double dot( Vector2d v )
	{
		return x*v.x + y*v.y;
	}
	
   // get angle [radians] the vector creates with OX axis
	public double angle()
	{
		return Math.atan2( x, y );
	}
	
	// return length of vector
	public double length()
	{
		return Math.sqrt( x*x + y*y );
	}
	
	// return square length of vector
	public double abs()
	{
		return x*x + y*y;
	}
	
	// overriden toString method for writing the contents of the vector
	public String toString()
	{
		return '(' + new Double(x).toString() + ',' + new Double(y).toString() + ')';
	}
	
	// compare with other Vector2d
	public boolean equals( Vector2d other )
	{
	   if ( other.x == x && other.y == y )
	      return true;
	   else
	      return false;
	}
	
	
	/* 
	 * static methods
	 */
	 
	/* compute distance between two points
	 */
	public static double distance( Vector2d v1, Vector2d v2 )
   {
      double dx = v1.x - v2.x;
      double dy = v1.y - v2.y;
      return Math.sqrt( dx*dx + dy*dy );
   }

}
