package romz.component.movement.center;

import static romz.math.RobotMath.distance;
import static romz.math.RobotMath.heading;
import static romz.math.RobotMath.min;
import romz.component.movement.Movement;
import romz.model.Situation;
import romz.model.advice.MovementAdvice;
import romz.model.robot.Robot;

public class CenterCircleMovement implements Movement {

	@Override
	public MovementAdvice getMovementAdvice(Situation situation) {
		MovementAdvice movementAdvice = new MovementAdvice();
		movementAdvice.heading = heading(situation.hero.x, situation.hero.y, situation.battleField.width / 2, situation.battleField.height / 2);
		double distanceToCenter = distance(situation.hero.x, situation.hero.y, situation.battleField.width / 2, situation.battleField.height / 2);
		if (distanceToCenter + 2 * Robot.ROBOT_SIZE < min(situation.battleField.height, situation.battleField.width)) {
			movementAdvice.heading += 90;
		}
		movementAdvice.direction = 1;
		movementAdvice.distance = 100;
		return movementAdvice;
	}

}
