package tzu.event;

import robocode.*;
import tzu.util.*;


/**
 * Maintains useful data on your AdvancedRobot's movement.
 */
public final class MoveTracker extends Condition implements Constants {

    static AdvancedRobot myRobot;
    static double prevStopX;
    static double prevStopY;
    static double prevSpeed;


    /**
     * Create a new RobotStoppedCondition object.
     */
    public MoveTracker(AdvancedRobot ar) {

        super("RobotStoppedEvent");
        myRobot = ar;
        prevSpeed = 0.0;
    }

    /**
     * Updates move data.
     * @return always false
     */
    public boolean test() {

        if (myRobot.getVelocity() == 0.0 ||
            myRobot.getVelocity() * prevSpeed < 0) {
            prevStopX = myRobot.getX();
            prevStopY = myRobot.getY();
        }
        prevSpeed = myRobot.getVelocity();
        return false;
    }

    /**
     * Returns the line of sight distance from your robot's last stop.
     */
    public double distanceFromLastStop() {

        return BotMath.calcDistance(
                prevStopX, prevStopY,
                myRobot.getX(), myRobot.getY());
    }
}
