package jam.tools;
import robocode.*;
import robocode.util.*;
import java.awt.geom.*
;import java.util.*;
import java.util.zip.*;
import java.io.*;

/**
 * 	Narcissus
	
	A self-graphing tool for robocode.
	See http://robowiki.net/perl/robowiki?Narcissus
 */
public class Narcissus
{
	static final double WALL_FACTOR = .8;
	static final int GF_ZERO = 15;
	static final int GF_ONE = 2*GF_ZERO;
	
	// wall approach, acceleration, lateral velocity, bullet flight time, guessfactors 
	int[][][][][] guessFactors = new int[2][3][3][10][GF_ONE + 1];
	Rectangle2D.Double BF;
	
	boolean enemyHasFired;
	double bearingDirection;
	double enemyEnergy;
	double enemyFirePower;
	double lastVelocity;
	double velocity;
	double lateralVelocity;
	double heading;
	Point2D.Double enemyLocation = new Point2D.Double();
	Point2D.Double myLocation = new Point2D.Double();
	double myBearing;
	double time;
	double enemyDistance;
	AdvancedRobot me;
	Vector enemyWaves = new Vector();
	String enemyName;
	boolean collectData = true;
	boolean onlyOnFire = false;
	double defaultBulletPower = 0;
	public Narcissus(){
		
	}
	
	public void newRound(AdvancedRobot me){
		this.me = me;
		
		BF = new Rectangle2D.Double(18, 18, me.getBattleFieldWidth() - 36, me.getBattleFieldHeight() - 36);
		enemyWaves.clear();	
		enemyFirePower = defaultBulletPower;
		
	}
	
	public void setCollectData(boolean b){
		collectData = b;
	}
	
	public void setDefaultFirePower(double dbp){
		
		defaultBulletPower = dbp;	
	}
	
	public void setOnlyOnFire(boolean b){
		
		onlyOnFire = b;	
	}
	
	private void createWave() {
		
		EnemyWave w = new EnemyWave();
		w.bulletVelocity = bulletVelocity(enemyFirePower);
		w.fireLocation = enemyLocation;
		w.fireTime = time;
		w.targetLocation = myLocation;
		w.bearingDirection = bearingDirection;
		Point2D.Double projection = projectMotion(myLocation, heading, WALL_FACTOR*velocity*enemyDistance/w.bulletVelocity);
		int wallIndex = BF.contains(projection) ? 0 : 1;
		
		int bftIndex = Math.min(9, (int)(enemyDistance/10/w.bulletVelocity));
		
		int accelIndex = (int)Math.round(Math.abs(velocity) - Math.abs(lastVelocity));
		if (accelIndex != 0)
			accelIndex = (accelIndex < 0)? 2 : 1;
		int latVelIndex = (int)(Math.abs(lateralVelocity)/3);
		
		w.waveGFs = guessFactors[wallIndex][accelIndex][latVelIndex][bftIndex];
		enemyWaves.add(w);
		
	}
	
	public void onScannedRobot(ScannedRobotEvent e){
		
		if (enemyName == null)
			enemyName = e.getName();
			
		boolean enemyFired = false;
		double eDrop = enemyEnergy - e.getEnergy();
		if (eDrop > 0 && eDrop <= 3){
			enemyFirePower = eDrop;
			enemyFired = true;
		}
		
		if (enemyFirePower > 0 && collectData && me.getEnergy() > 0 && (!onlyOnFire || enemyFired))
			createWave();	//create a wave using last turn's stats and this turn's firepower;

		
		/* ------ Data setup ------ */
		myLocation = new Point2D.Double(me.getX(), me.getY());
		double enemyAbsoluteBearing = me.getHeadingRadians() + e.getBearingRadians();
		enemyDistance = e.getDistance();
		enemyLocation = projectMotion(myLocation, enemyAbsoluteBearing, enemyDistance);
		myBearing = absoluteBearing(enemyLocation, myLocation);
		time = me.getTime();
		enemyEnergy = e.getEnergy();
		lastVelocity = velocity;
		velocity = me.getVelocity();
		heading = me.getHeadingRadians();
		lateralVelocity = velocity*Math.sin(heading - myBearing);
		if (lateralVelocity != 0)
			bearingDirection = lateralVelocity > 0 ? 1 : -1;
		/* ------ Wave update ------- */
		if (collectData)
			for (Enumeration en = enemyWaves.elements(); en.hasMoreElements();) {
				EnemyWave w	= (EnemyWave)en.nextElement();
				if (w.test(time, myLocation))
					enemyWaves.remove(w);
			}
		
	}
	
	public void saveData(){
		
		try  {
			ObjectOutputStream out = new ObjectOutputStream(new GZIPOutputStream(new RobocodeFileOutputStream(me.getDataFile(enemyName + ".narc"))));
			out.writeObject(new double[26]);
			out.writeObject(new double[26]);
			out.writeObject(guessFactors);
			out.close();
		}
		catch (IOException ex){}
		catch (Exception ex) {saveData();}
	}
	
	private static Point2D.Double projectMotion(Point2D.Double loc, double heading, double distance){
		
		return new Point2D.Double(loc.x + distance*Math.sin(heading), loc.y + distance*Math.cos(heading));			
	}
	
    private static double maxEscapeAngle(double bulletVelocity) {
		return Math.asin(9D / bulletVelocity);
    }


    private static double bulletVelocity(double power) {
        return 20 - 3 * power;
    }

    private static double absoluteBearing(Point2D source, Point2D target) {
        return Math.atan2(target.getX() - source.getX(), target.getY() - source.getY());
    }

	private static int toGF(double angle){
		return (int)Math.round((angle + 1D)*GF_ZERO);
	}
	
	class EnemyWave {
		
		double bulletVelocity;
		Point2D.Double fireLocation;
		double fireTime;
		Point2D.Double targetLocation;
		double bearingDirection;
		int[] waveGFs;
		
		public boolean test(double time, Point2D.Double location){
		
			if (bulletVelocity*(time - fireTime) >= fireLocation.distance(location)){
				double angle = bearingDirection*Utils.normalRelativeAngle(absoluteBearing(fireLocation, location) - absoluteBearing(fireLocation, targetLocation));
				angle /= maxEscapeAngle(bulletVelocity);
				int gf = toGF(angle);
				if (gf >=0 && gf <= GF_ONE)
					waveGFs[gf]++;
				return true;
			}
			return false;
		}
		
	}
}
