package SHAM;

import robocode.*;
import java.awt.*;
import java.awt.geom.*;
import java.*;


/**
 * 
 * SHAM.WOW created by Steven Hatton and Aditya Majumdar Period 3, JAVA
 * Programming Due: 06/05/09 Robocode, JAVA, Second Semester Final Project
 * 
 * 
 * Linear Targeting gun - fairly simple. Once again, uses pluggable framework.
 * Form of predictive targeting. Aims ahead of robot.
 */
public class LG
{
    private AdvancedRobot _robot;


    public LG( AdvancedRobot robot )
    {
        _robot = robot;
    }

    private AdvancedEnemyBot enemy = new AdvancedEnemyBot();


    // start gun
    public void onScannedRobot( ScannedRobotEvent e )
    {
        // don't fire if there's no enemy
        if ( enemy.none() || e.getDistance() < enemy.getDistance() - 70
            || e.getName().equals( enemy.getName() ) )
        {
            enemy.update( e, this._robot );
        }

        // convenience variable
        double max = Math.max( _robot.getBattleFieldHeight(),
            _robot.getBattleFieldWidth() );
        // calculate firepower based on distance
        double firePower = Math.min( 500 / enemy.getDistance(), 3 );

        // calculate speed of bullet
        double bulletSpeed = 20 - firePower * 3;

        // distance = rate * time, solved for time
        long time = (long)( enemy.getDistance() / bulletSpeed );
        // calculate gun turn to predicted x,y location
        double futureX = enemy.getFutureX( time );
        double futureY = enemy.getFutureY( time );
        double absDeg = absoluteBearing( _robot.getX(),
            _robot.getY(),
            futureX,
            futureY );

        // turn the gun to the predicted x,y location
        _robot.setTurnGunRight( normalizeBearingDegrees( absDeg
            - _robot.getGunHeading() ) );
        if ( _robot.getGunHeat() == 0 && _robot.getGunTurnRemaining() <= 3 )
        {
            _robot.setFire( firePower );
        }
    }


    double absoluteBearing( double x1, double y1, double x2, double y2 )
    {
        return Math.toDegrees( Math.atan2( x2 - x1, y2 - y1 ) );
    }


    double normalizeBearingDegrees( double angle )
    {
        while ( angle > 180 )
            angle -= 360;
        while ( angle < -180 )
            angle += 360;
        return angle;
    }


    public void onHitByBullet( HitByBulletEvent e )
    {
    }


    public void onRobotDeath( RobotDeathEvent e )
    {
        if ( e.getName().equals( enemy.getName() ) )
        {
            enemy.reset();
        }
    }

}