package nat;

import nat.base.BotBase;
import nat.gun.meteor.Meteor;
import nat.gun.meteorite.Meteorite;
import nat.move.HawkOnFireMove;
import nat.radar.DuelRadar;
import nat.radar.MeleeRadar;

public class Pallas extends BotBase {
	private boolean isMelee;

	private MeleeRadar meleeRadar;
	private DuelRadar duelRadar;
	
	private HawkOnFireMove hawkMove;
	
	private Meteorite meteorite;
	private Meteor meteor;

	@Override
	protected final void init() {
		setColors(RobotColor.getBodyColor(), RobotColor.getScanArcColor(),
				RobotColor.getGunColor(), RobotColor.getRadarColor());

		isMelee = getOthers() > 1;

		meleeRadar = new MeleeRadar(getLogger(), getGraphicsDrawer());
		duelRadar = new DuelRadar(getLogger(), getGraphicsDrawer());
		
		hawkMove = new HawkOnFireMove();
		
		meteorite = new Meteorite(getLogger(), getGraphicsDrawer());
		meteor = new Meteor(getLogger(), getGraphicsDrawer());

		if (isMelee) {
			initMelee();
		} else {
			initOneOnOne();
		}
	}

	private final void initMelee() {
		addEventListener(meleeRadar);
		setRadar(meleeRadar);
		
		addEventListener(hawkMove);
		setMovement(hawkMove);
		
		addEventListener(meteor);
		setGun(meteor);
	}

	private final void initOneOnOne() {
		initMelee();
		changeToOneOnOne();
	}

	private final void changeToOneOnOne() {
		isMelee = false;

		removeEventListener(meleeRadar);
		
		addEventListener(duelRadar);
		setRadar(duelRadar);
	}

	@Override
	protected final void runTick() {
		if (isMelee && getOthers() == 1) {
			changeToOneOnOne();
		}
	}
}
