package nat.base;

import nat.base.actors.*;
import nat.gfx.RobocodeGraphics;
import nat.utils.M;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.Condition;
import robocode.CustomEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.StatusEvent;
import robocode.WinEvent;
import robocode.TeamRobot;

/**
 * @author Alexander Schultz (original)
 * @author Nat Pavasant (modified)
 */
abstract public class BotBase extends TeamRobot {
	private boolean runYet = true;
	public static Rectangle2D BATTLEFIELD;
	
	static {
		M.init();
	}

	public class RunEvent extends Condition {
		public RunEvent() {
			super("Robot Setter", 8);
		}

		@Override
		public boolean test() {
			// logger.log("IN MAIN ROBOT LOOP " + getPriority());
			runYet = false;
			return false;
		}
	}

	private GunActor gunActor;
	private MovementActor movementActor;
	private RadarActor radarActor;

	private Logger logger;
	private RobocodeGraphics graphics;

	private Gun gun;
	private Movement movement;
	private Radar radar;

	private ArrayList<EventListener> listeners = new ArrayList<EventListener>();

	public final Logger getLogger() {
		return logger;
	}

	public final RobocodeGraphics getGraphicsDrawer() {
		return graphics;
	}

	protected final void setMovement(Movement move) {
		movement = move;
	}

	protected final void setGun(Gun g) {
		gun = g;
	}

	protected final void setRadar(Radar r) {
		radar = r;
	}

	protected final void addEventListener(EventListener el) {
		listeners.add(el);
	}

	protected final void removeEventListener(EventListener el) {
		listeners.remove(el);
	}

	public final void onCustomEvent(CustomEvent arg0) {
		Delegate.delegate(listeners, arg0);
		update(arg0);
	}

	public final void onBulletHit(BulletHitEvent arg0) {
		Delegate.delegate(listeners, arg0);
		update(arg0);
	}

	public final void onBulletHitBullet(BulletHitBulletEvent arg0) {
		Delegate.delegate(listeners, arg0);
		update(arg0);
	}

	public final void onBulletMissed(BulletMissedEvent arg0) {
		Delegate.delegate(listeners, arg0);
		update(arg0);
	}

	public final void onDeath(DeathEvent arg0) {
		Delegate.delegate(listeners, arg0);
		update(arg0);
	}

	public final void onHitByBullet(HitByBulletEvent arg0) {
		Delegate.delegate(listeners, arg0);
		update(arg0);
	}

	public final void onHitRobot(HitRobotEvent arg0) {
		Delegate.delegate(listeners, arg0);
		update(arg0);
	}

	public final void onHitWall(HitWallEvent arg0) {
		Delegate.delegate(listeners, arg0);
		update(arg0);
	}

	public final void onRobotDeath(RobotDeathEvent arg0) {
		Delegate.delegate(listeners, arg0);
		update(arg0);
	}

	public final void onScannedRobot(ScannedRobotEvent arg0) {
		// logger.log("IN ON SCANNED ROBOT");
		Delegate.delegate(listeners, arg0);
		update(arg0);
	}

	public final void onStatus(StatusEvent arg0) {
		// logger.log("IN ON STATUS");
		Time time = new Time(getTime(), getOthers(), getRoundNum(),
				getNumRounds());
		Delegate.delegate(listeners, arg0, time);
		update(arg0);
	}

	public final void onWin(WinEvent arg0) {
		Delegate.delegate(listeners, arg0);
		update(arg0);
	}

	public final void onSkippedTurn(SkippedTurnEvent arg0) {
		Delegate.delegate(listeners, arg0);
		update(arg0);
		logger.log("WARNING: turn skipped.");
	}

	@Override
	public final void onKeyPressed(KeyEvent e) {
		graphics.onKeyPressed(e);
	}

	public void setColors(final Color bodyColor, final Color scanColor,
			final Color gunColor, final Color radarColor) {
		this.setBodyColor(bodyColor);
		this.setScanColor(scanColor);
		this.setGunColor(gunColor);
		this.setRadarColor(radarColor);
	}

	abstract protected void init();

	private final void preInit() {
		// Set turning to be independent
		this.setAdjustGunForRobotTurn(true);
		this.setAdjustRadarForRobotTurn(true);
		this.setAdjustRadarForGunTurn(true);

		// Set up actors
		gunActor = new GunActor(this);
		movementActor = new MovementActor(this);
		radarActor = new RadarActor(this);

		// Set up logger
		logger = new Logger(this);
		graphics = new RobocodeGraphics();

		// Set up custom event
		addCustomEvent(new RunEvent());
		
		BATTLEFIELD = new Rectangle2D.Double(18d, 18d, getBattleFieldWidth() - 36d, getBattleFieldHeight() - 36d);
	}

	@Override
	public final void run() {
		preInit();
		init();
		while (true) {
			if (!runYet)
				_runTick();
			execute();
		}
	}

	private final void _runTick() {
		if (radar != null)
			radar.doRadar(radarActor);
		if (movement != null)
			movement.doMovement(movementActor);
		if (gun != null)
			gun.doGun(gunActor);
		runTick();
	}

	protected void runTick() {
	}

	protected void update(CustomEvent arg0) {
	}

	protected void update(BulletHitEvent arg0) {
	}

	protected void update(BulletHitBulletEvent arg0) {
	}

	protected void update(BulletMissedEvent arg0) {
	}

	protected void update(DeathEvent arg0) {
	}

	protected void update(HitByBulletEvent arg0) {
	}

	protected void update(HitRobotEvent arg0) {
	}

	protected void update(HitWallEvent arg0) {
	}

	protected void update(RobotDeathEvent arg0) {
	}

	protected void update(ScannedRobotEvent arg0) {
	}

	protected void update(StatusEvent arg0) {
	}

	protected void update(WinEvent arg0) {
	}

	protected void update(SkippedTurnEvent arg0) {
	}

	@Override
	public final void onPaint(Graphics2D g) {
		if (!runYet)
			_runTick();
		runYet = true;
		graphics.onPaint(g);
	}
}