package kawigi.mini;
import robocode.*;
import java.util.*;
import java.awt.geom.*;
import java.awt.*;
/*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*
 * Coriantumr - a mini melee robot by Kawigi.  Stained with the blood of Shiz.								*
 *	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*
 * Coriantumr was a sort of warlord attempting to seize control of a fallen government.  It was prophesied	*
 * to him that if he continued warring, he would witness the destruction of his entire civilization and		*
 * see another take its place.  When he killed Shiz, he became the only survivor that war, and wandered		*
 * into the people that would populate the land of his ancestors.											*
 *	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*
 * Version 1.0 - first release.  Minimum risk movement centered around not being picked as a target, guess	*
 * 		factor gun segmented on whether it's a melee or not, acceleration for one-on-one or lateral			*
 * 		direction for melee (advancing, lateral, retreating), and projected bullet flight time.				*
 *	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*
 * Version 1.1 - first revision.  Tweaked around the movement formulas, particularly making it less			*
 * 		predictable in one-on-one battles.  All-in-all, though, the most significant change is that I		*
 * 		introduced some code to prevent me from shooting at walls.  This seems to help solve a problem I've	*
 *		had with having substandard bullet damage (or overachieved survival maybe) against robots of a		*
 *		similar calibur.  Hopefully this is the 1700's release.  Also, thanks to David for helping me see	*
 *		a logical problem with my movement algorithm when the battle gets smaller.							*
 *	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*
 * Ideas borrowed from:																						*
 *	+ My own FloodHT																						*
 *	+ Code from Troodon																						*
 *	+ HawkOnFire/GlowBlowMelee - Rozu mentioned some stuff about their system on the wiki and repository	*
 *	+ Nimrod's code - at the time of writing, the most effective open-source melee bot						*
 *	+ Everything David refused to tell me about DuelistMiniMelee which just confirmed my ideas				*
 *	+ Probably 2 or 3 others I can't remember anymore														*
 *	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*
 * This code is released under the terms of the KPL (http://robowiki.net/perl/robowiki?KawigiPublicLicense)	*
 * For more information, visit the RoboWiki (http://robowiki.net/perl/robowiki?Coriantumr)					*
 *	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*	*/
public class Coriantumr extends AdvancedRobot
{
	static Point2D myLocation, last;
	static EnemyInfo currentTarget;
	//having one permanent hash map and one one-round-only hashmap for
	//different types of enemy data seems to be very clean.  I might even
	//do it in the next release of FloodHT...
	static HashMap enemies;
	static HashMap stats = new HashMap();
	
	public void run()
	{
		//I worked for hours on these colors, so I hope people appreciate and FEAR them.
		setColors(Color.red, Color.white, Color.gray);
		setAdjustGunForRobotTurn(true);
		setTurnRadarRight(Double.POSITIVE_INFINITY);
		//meant to be reinitialized every round.  Wouldn't even be static except that they're smaller that way.
		enemies = new HashMap();
		Point2D next = currentTarget = null;
		do
		{
			myLocation = new Point2D.Double(getX(), getY());
			if (currentTarget != null)
			{
				if (next == null)
					next = last = myLocation;
				if (next.distance(myLocation) < 15 || getOthers() > 1)
				{
					boolean changed = false;
					double angle = 0;
					double moveDist = myLocation.distance(currentTarget);
					moveDist = (getOthers() == 1 ? Math.random()*moveDist : Math.min(500, moveDist))*.5;
					//sometimes I'll change my point here, sometimes I won't.  It's a big mystery!
					do
					{
						Point2D p;
						if (inField(p = projectPoint(myLocation, angle, moveDist)) && findRisk(p) < findRisk(next))
						{
							changed = true;
							next = p;
						}
						angle += .1;
					}
					while (angle < Math.PI*2);
					//this helps the whole movement system know what direction I'm going, and avoid head-on targeting:
					if (changed)
						last = myLocation;
				}
				//Thanks, David, for a quick way of doing this:
				double a1, a2;
				setTurnRightRadians(a1 = Math.atan(Math.tan(a2 = robocode.util.Utils.normalRelativeAngle(angle(next, myLocation) - getHeadingRadians()))));
 				setAhead(Math.abs(getTurnRemainingRadians()) > 1 ? 0 : (a1 == a2 ? 1.0 : -1.0) * next.distance(myLocation));
			}
			execute();
		}
		while (true);
	}
	
	private double findRisk(Point2D point)
	{
		double risk = 0;
		Collection enemySet;
		Iterator it = (enemySet = enemies.values()).iterator();
		do
		{
			EnemyInfo e = (EnemyInfo)it.next();
			//start with an anti-gravity-type value:
			double thisrisk = (e.energy+50)/point.distanceSq(e);
			//woah, nested iterations!  Here, I'm counting the enemies that are closer to e than the proposed point is.
			//The more, the better, since this robot would be less likely to target me.
			int closer = 0;
			Iterator it2 = enemySet.iterator();
			do
			{
				EnemyInfo e2 = (EnemyInfo)it2.next();
				if (e.distance(e2)*.9 > e.distance(point))
					closer++;
			}
			while (it2.hasNext());
			//try this, multiply this number by the number of enemies to which I would be the closest:
			//if they are likely targeting me, multiply by some factor that has to do with "perpendicularity"
			//(I think I remember David Alves calling it that):
			if (closer <= 1 || e.lastHit > getTime()-200 || e == currentTarget)
			{
				//I had to think about this one, but I think DuelistMicroMelee helped me make sure that it was correct.  I can't remember anymore.
				thisrisk *= 2+2*Math.abs(Math.cos(angle(myLocation, point) - angle(e, myLocation)));
			}
			//don't run into people!  (This is a guess of whether someone is between me and p)
			//I suppose this deserves an explanation.  I'm figuring that if to 36x36 squares will hit each other moving
			//along a certain vector (my vector, and I assume they'll be in roughly the same place), then a line
			//representing the vector will intersect a 72x72 square centered in the same place.
			//if (new Line2D.Double(myLocation, point).intersects(new Rectangle2D.Double(e.x-36, e.y-36, 72, 72)))
			//	thisrisk *= 4;
			risk += thisrisk;
		}
		while (it.hasNext());
		//add a small antigravity value to the point I was at before now, just to kind of push me in straight
		//lines (this made me too hitable in one-on-one, though):
		if (getOthers() > 1)
			risk += Math.random()/last.distanceSq(point);
		//and repel my current location, to make it more likely that I change my mind before I get to my assigned
		//point (and less likely to change my mind right away maybe):
		risk += Math.random()/5/myLocation.distanceSq(point);
		return risk;
	}
	
	public void onScannedRobot(ScannedRobotEvent e)
	{
		String name;
		EnemyInfo enemy = (EnemyInfo)enemies.get(name = e.getName());
		if (enemy == null)
			enemies.put(name, enemy = new EnemyInfo());
		int[][][][] currentStats = (int[][][][])stats.get(name);
		if (currentStats == null)
		{
			//Segmentations: melee/one-on-one, lateral direction (melee)/acceleration (one-on-one), bft, guessfactors
			//reduced guessfactors simply because it learns a bit faster, I'm not saving, and melee is all
			//fuzzy anyways.  It occurred to me that my acceleration segmentation primarily doesn't work with
			//tons of missed scans (sometimes 15 or so at a time while I lock the other way)
			stats.put(name, currentStats = new int[2][3][13][31]);
		}
		double distance, absBearing;
		Point2D loc, myLocation;
		//wasn't making my enemies Point2D objects a good idea?
		enemy.setLocation(loc = projectPoint(myLocation = new Point2D.Double(getX(), getY()), absBearing = getHeadingRadians()+e.getBearingRadians(), distance = e.getDistance()));
		
		if (currentTarget == null || distance < myLocation.distance(currentTarget))
			currentTarget = enemy;
		double velocity;
		int accl = (int)Math.round(Math.abs(enemy.velocity)-Math.abs(enemy.velocity = velocity = e.getVelocity()));
		if (accl != 0)
			accl = (accl < 0) ? 1 : 2;
		double latd = e.getHeadingRadians()-absBearing;
		double bulletv;
		double power;
		//w00t - classic minibot code!
		double energy;
		int[] current = currentStats[Math.min(getOthers()-1, 1)][getOthers() == 1 ? accl : (int)(Math.cos(latd)*velocity/Math.abs(velocity)*1.4+1.4)][(int)(distance/(bulletv = 20-3*(power = Math.min(Math.min(3, 1200/distance), Math.min(getEnergy(), energy = enemy.energy = e.getEnergy())/4)))/15)];
		//problem with this code is that it will default to 1 if the velocity is zero, instead of defaulting the last observed value:
		double direction = (((Math.sin(latd)*velocity)< 0) ? -1 : 1)*Math.asin(8/bulletv);
		
		Vector waves = enemy.waves;
		int i=waves.size();
		while (i > 0)
		{
			i--;
			if (((MeleeBullet)waves.elementAt(i)).updateEnemy(loc, getTime()))
				waves.removeElementAt(i);
		}
		MeleeBullet wave;
		waves.add(wave = new MeleeBullet());
		wave.startPoint = myLocation;
		wave.startgunheading = absBearing;
		wave.direction = direction;
		wave.lastPoint = loc;
		wave.bulletspeed = bulletv;
		wave.lasttime = getTime();
		wave.segment = current;
		
		if (enemy == currentTarget)
		{
			int bestindex = 15;
			//i is zero from before, let's just use it :-)
			double shotBearing = absBearing;
			if (energy > 0)
				do
				{
					//the extension to this if statement is my clever idea to avoid shooting at the wall.  Hope it helps.
					double tempBearing;
					if (inField(projectPoint(myLocation, tempBearing = absBearing + direction*(i/15.0-1), e.getDistance()*(bulletv/(bulletv+8)))) && current[i] > current[bestindex])
					{
						bestindex = i;
						shotBearing = tempBearing;
					}
					i++;
				}
				while (i < 31);
			
			if (getOthers() == 1 || getGunHeat() < .8)
				setTurnRadarLeft(getRadarTurnRemaining());
			//note - I probably changed absBearing before attempting this:
			setTurnGunRightRadians(robocode.util.Utils.normalRelativeAngle(shotBearing-getGunHeadingRadians()));
			//a good enough constant for both:
			if (Math.max(Math.abs(getGunTurnRemaining()), energy/getEnergy()) < 5)
				setFire(power);
		}
	}
	
	public void onHitByBullet(HitByBulletEvent e)
	{
		EnemyInfo enemy;
		if ((enemy = (EnemyInfo)enemies.get(e.getName())) != null)
			enemy.lastHit = getTime();
	}
	
	public void onRobotDeath(RobotDeathEvent e)
	{
		//the EnemyInfo objects are volitile and made for a round at a time, so I can sacrifice them when they die:
		if (enemies.remove(e.getName()) == currentTarget)
			currentTarget = null;
	}
	
	/*	someday I'll have room for a cool victory dance:
	public void onWin(WinEvent e)
	{
		setTurnRight(Double.POSITIVE_INFINITY);
		setTurnGunRight(Double.NEGATIVE_INFINITY);
		int i=0;
		do
		{
			setFire(0);
			ahead(100);
			setFire(0);
			back(100);
			i++;
		}
		while (i < 5);
	} */
	
	//utility functions, I figure anyone making a goto bot has something like these, and they
	//come in useful in a lot of other random places, too:
	public static Point2D projectPoint(Point2D startPoint, double theta, double dist)
	{
		return new Point2D.Double(startPoint.getX() + dist * Math.sin(theta), startPoint.getY() + dist * Math.cos(theta));
	}
	
	//This strange habit of putting point2 before point1 in this method - and the funny thing is I think
	//I've seen other people do the same thing:
	public static double angle(Point2D point2, Point2D point1)
	{
		return Math.atan2(point2.getX()-point1.getX(), point2.getY()-point1.getY());
	}
	
	//returns true if a point is within a truncated field
	public boolean inField(Point2D p)
	{
		return new Rectangle2D.Double(30, 30, getBattleFieldWidth()-60, getBattleFieldHeight()-60).contains(p);
	}
}
