package extra;
import robocode.*;
import java.awt.Color;
import static robocode.util.Utils.normalRelativeAngleDegrees;

public class Sauce extends AdvancedRobot {
  boolean movingForward;
	public void run() {
		setBodyColor(new Color(255, 140, 0));
		setGunColor(new Color(255, 215, 0));
		setRadarColor(new Color(220, 20, 60));
		setBulletColor(new Color(255, 255, 255));
		setScanColor(new Color(128, 128, 128));
		
		setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
		while(true) {
          back(250);
          ahead(250);
		}
	}

	public void onScannedRobot(ScannedRobotEvent e) {
	double absoluteBearing = getHeading() + e.getBearing();
	double bearingFromGun = normalRelativeAngleDegrees(absoluteBearing - getGunHeading());
	setTurnRight(e.getBearing() + 90);

    setTurnRadarLeftRadians(getRadarTurnRemainingRadians());
if (getGunHeat() == 0) {
				setFire(Math.min(3 - Math.abs(bearingFromGun), getEnergy() - .1));
			}
		
		else {
			setTurnGunRight(bearingFromGun);
		}
		if (bearingFromGun == 0) {
			scan();
		}
	}
	

	public void onHitByBullet(HitByBulletEvent e) {

	}
	
public void reverseDirection() {
		if (movingForward) {
			setBack(250);
			movingForward = false;
		} else {
			setAhead(250);
			movingForward = true;
		}
	}
	public void onHitWall(HitWallEvent e) {
     reverseDirection();
	}	
}
					