package dam.movement;

import java.util.*;

import dam.Target;

public class ClassicMovement extends MovementStrategy
{
	private static int OPTIMUM_DISTANCE = 300;
	/**
	* Melee movement
	*/
	public void doMove()
	{
		Target target = bot.getTarget();
		boolean dodge = (rand.nextInt(3) == 1);
		if(dodge){
			if(target.shouldDodge(getTime())) direction *= -1;
		}
		double angle = bot.normaliseBearing(target.getBearing() - (PI/2));
		double distance = target.getDistance();
		double extra = 0;
		double dist = distance - OPTIMUM_DISTANCE;
		extra = (dist/1000) * (PI/2) * direction;
		setTurnRightRadians(angle + extra);
		setAhead(direction * 200);
		setMoveCount(getTime() + 1); // we update our moves each time through the loop
	}
	
	
	public void onNearWall()
	{
		AntiGravity g = new AntiGravity(getBattleFieldWidth(), getBattleFieldHeight());
		g.calculate(getX(), getY(), bot.getHeadingRadians());
		direction = g.getDirection();
		double angle = g.getAngle();		
		setTurnRightRadians(angle);
		setAhead(direction * 200);
		setMoveCount(getTime() + 10);
	}



}