package dam.targetting;

import java.util.*;
import java.io.*;

import dam.targetting.*;

import dam.MasterBot;
import dam.BasicTarget;
import dam.movement.*;


/**
 * @author David Mold
 *
 * The Target Module is used to determine the current targetting strategy
 * needed for the Target. Jun 26, 2002
 */
public class TargetModule implements Serializable
{	
	private transient MasterBot bot;
	private BasicTarget target;
	private TargettingStrategy strat;
	private PatternTargetting pattern = new PatternTargetting();
	private TargettingStrategy circular = new CircularTargettingSimple();
	
	public TargetModule(MasterBot bot, BasicTarget t)
	{
		this.bot = bot;
		this.target = t;
		pattern.setBot(bot);
		circular.setBot(bot);		
		pattern.setTarget(t);
		circular.setTarget(t);
		strat = circular;		
	}
		
	public void setBot(MasterBot bot){
		this.bot = bot;
		pattern.setBot(bot);
		circular.setBot(bot);
	}
	
	public MasterBot getBot(){ return bot; }
		
	public TargettingStrategy getDefaultStrategy()
	{
		return circular;
	}
		
		
	public TargettingStrategy getStrategy()
	{	
		return strat;
	}
	
	/**
	 * Check out the score, and choose the most accurate shooting method
	 */
	public void update()
	{
		if(bot.getOthers() > 1){ // melee, we can use circular
			pattern.guess(target.getLastScanTime() + 10);
			if(pattern.isHeld()){
				strat = circular;
			}
			else strat = pattern;
		}
		else{
			//if((bot.getRoundNum() > 2) && (target.getAccuracy() < 0.18)){
			//	strat = circular;
			//}
			//else{
				if(!pattern.isLocked()) pattern.guess(target.getLastScanTime() + 10);
				if(pattern.isLocked()) strat = pattern;
				else strat = circular;
			//}
		}
	}
}

