package ers.micro.ISuck;
 
/**
 * Creator: ER Samson
 * 
 * Credits:
 * Movement - https://mark.random-article.com/robocode/improved_movement.html
 * 			  https://robowiki.net/wiki/User:Exauge/snippets
 *            https://robowiki.net/wiki/Oscillator_Movement
 * 
 * Radar - http://robowiki.net/wiki/One_on_One_Radar
 * 
 * Gun Targetting - https://robowiki.net/wiki/Aristocles
 *					https://robowiki.net/wiki/User:Exauge/snippets#Pattern_Matching_Gun
 *                  https://robowiki.net/wiki/WeekendObsession
 * 
 * Tips from Sheldor and Skilgannon's Yatagan - https://robowiki.net/wiki/Yatagan
 * 
 * Symbolic Pattern String from Sheldor's Foilist - https://robowiki.net/wiki/Foilist
 */

import robocode.*;
import robocode.util.Utils;
import java.awt.*;
import java.awt.geom.*;

public class ISuckMicro extends AdvancedRobot {

	// Guess Factor Variables
	static final double BATTLE_FIELD_WIDTH = 800;
    static final double BATTLE_FIELD_HEIGHT = 600;
    static final double MAX_DISTANCE = 900;
    static final double MAX_BULLET_POWER = 3.0;
    static final double BULLET_POWER = 2.0;
    static final double WALL_MARGIN = 36;
	static final double MAX_TRIES = 100; // Movement wall smoothing

    static final int DISTANCE_INDEXES = 5;
    static final int VELOCITY_INDEXES = 5;
    static final int LAST_VELOCITY_INDEXES = 5;
    static final int WALL_INDEXES = 2;
    static final int DECCEL_TIME_INDEXES = 6;
    static final int AIM_FACTORS = 25;
    static final int MIDDLE_FACTOR = (AIM_FACTORS - 1) / 2;

    static Point2D enemyLocation;
    static double enemyVelocity;
    static int timeSinceDeccel;
    static double bearingDirection;
    static int[][][][][][] aimFactors = new int[DISTANCE_INDEXES][VELOCITY_INDEXES][LAST_VELOCITY_INDEXES]
											   [DECCEL_TIME_INDEXES][WALL_INDEXES][AIM_FACTORS];

	static final int ANTIRAM_FACTOR = 70;
	static final double NINETY_DEG = Math.PI/2;
	static double enemyEnergy;
	static int myMoveDirection = -1; 
	static int myDirectionIndex = 1;
	static int myDirectionLimit = 5;

	public void run() {
		// Color Identification
		setColors(Color.blue, Color.red, Color.orange);
		
		// Easy targetting and infinite radar movement
        setAdjustRadarForGunTurn(true);
        setAdjustGunForRobotTurn(true);
		turnRadarRightRadians(Double.POSITIVE_INFINITY);
	    do {
	        // Check for new targets.
	        // Only necessary for Narrow Lock because sometimes our radar is already
	        // pointed at the enemy and our onScannedRobot code doesn't end up telling
	        // it to turn, so the system doesn't automatically call scan() for us
	        // [see the javadocs for scan()].
	    	scan();
	    } while (true);
	}

	public void onScannedRobot(ScannedRobotEvent e) {
		// ---------- Generic Variables ----------
		Wave wave = new Wave();
		double enemyDistance;
		double enemyAbsoluteBearing;

		Rectangle2D fieldRectangle = new Rectangle2D.Double(WALL_MARGIN, 
															WALL_MARGIN,
		    												BATTLE_FIELD_WIDTH - WALL_MARGIN * 2, 
															BATTLE_FIELD_HEIGHT - WALL_MARGIN * 2);

		// ---------- Musashi Movement Logic ----------
		// Turn perpendicular to enemy, try to maintain distance, no wall avoidance D: 
	    // setTurnRightRadians(Math.cos((absB = e.getBearingRadians()) - (0.2 * mvD))); // Saving code size!
		// Movement based from Yatagan Nano
		setTurnRightRadians(Math.cos((enemyAbsoluteBearing = e.getBearingRadians()) + 
						   (180 - (enemyDistance = e.getDistance())) * (getVelocity() / 3000)));

		// ---------- Stop'n'Go Movement Logic ----------
		// Some "hard coded" intelligence, messes up PM/GF Guns, I hope ^^;;
		if (enemyEnergy > (enemyEnergy = e.getEnergy()) || enemyDistance <= (ANTIRAM_FACTOR * 2)) { // Adding distance checker
			setAhead((Math.random() * 70 + 50) * myMoveDirection);
			//setAhead((Math.random() * 120) * myMoveDirection); // This line saves code size by 4

			if (myDirectionIndex >= myDirectionLimit && enemyDistance > (ANTIRAM_FACTOR * 2)) {
				onHitWall(null); // Code saving mechanism, idea from Yatagan
				myDirectionIndex = 1;
				myDirectionLimit--;
			}
			
			if (myDirectionLimit < -2) {
				myDirectionLimit = (int)(Math.random() * 4 + 3);
			}
			myDirectionIndex++;
		}

		// ---------- Gun Logic ----------
		// GuessFactor Targeting Gun - Aristocles
		enemyLocation = project(wave.wGunLocation = new Point2D.Double(getX(), getY()), 
                               (enemyAbsoluteBearing += getHeadingRadians()), enemyDistance);		

		int lastVelocityIndex = (int)Math.abs(enemyVelocity) / 2;
		int velocityIndex = (int)Math.abs((enemyVelocity = e.getVelocity()) / 2);	

		if (velocityIndex < lastVelocityIndex) {
		   timeSinceDeccel = 0;
		}
		if (enemyVelocity != 0) {
	    	bearingDirection = enemyVelocity * Math.sin(e.getHeadingRadians() - enemyAbsoluteBearing) > 0 ?
				0.7 / (double)MIDDLE_FACTOR : -0.7 / (double)MIDDLE_FACTOR;
		}

		wave.wBearingDirection = bearingDirection;
		int distanceIndex = (int)(enemyDistance / (MAX_DISTANCE / DISTANCE_INDEXES));
		//wave.wBulletPower = Math.min(he / 4,
	    //	(distanceIndex = (int)(eD / (MAX_DISTANCE / DISTANCE_INDEXES))) > 1 ? BULLET_POWER : MAX_BULLET_POWER);
		// Removed original bullet power code
		wave.wBulletPower = Math.min(BULLET_POWER + (int)(ANTIRAM_FACTOR / enemyDistance), enemyEnergy / 4);
		
		wave.wAimFactors = aimFactors[distanceIndex][velocityIndex]
								     [lastVelocityIndex][Math.min(5, timeSinceDeccel++ / 13)]
	    	                         [fieldRectangle.contains(project(wave.wGunLocation, 
                                     	enemyAbsoluteBearing + wave.wBearingDirection * 13, enemyDistance)) ?
										1 : 0];
		wave.wBearing = enemyAbsoluteBearing;

		int mostVisited = MIDDLE_FACTOR, i = AIM_FACTORS;
		do  {
	    	if (wave.wAimFactors[--i] > wave.wAimFactors[mostVisited]) {
				mostVisited = i;
	    	}
		} while (i > 0);

		setTurnGunRightRadians(Utils.normalRelativeAngle(enemyAbsoluteBearing - getGunHeadingRadians() +
	    	wave.wBearingDirection * (mostVisited - MIDDLE_FACTOR)));

		setFire(wave.wBulletPower);
		if (getEnergy() >= BULLET_POWER) {
	    	addCustomEvent(wave);
		}

		// ---------- Radar Logic ---------- 
		// From RoboWiki
		//setTurnRadarLeft(getRadarTurnRemaining()); // This Line saves code size by 10
		setTurnRadarRightRadians(2 * Utils.normalRelativeAngle(enemyAbsoluteBearing - getRadarHeadingRadians()));
	}

	public void onHitWall(HitWallEvent e) {
		myMoveDirection = -myMoveDirection;
	}

    static Point2D project(Point2D sourceLocation, double angle, double length) {
        return new Point2D.Double(sourceLocation.getX() + Math.sin(angle) * length,
            sourceLocation.getY() + Math.cos(angle) * length);
    }

    static double absoluteBearing(Point2D source, Point2D target) {
        return Math.atan2(target.getX() - source.getX(), target.getY() - source.getY());
    }

	class Wave extends Condition {
		double wBulletPower;
		Point2D wGunLocation;
		double wBearing;
		double wBearingDirection;
		int[] wAimFactors;
		double wDistance;

		public boolean test() {
	    	if ((wDistance += (20 - (3 * wBulletPower))) > wGunLocation.distance(enemyLocation) - 18) {
				try {
		    		wAimFactors[(int)Math.round(((Utils.normalRelativeAngle(absoluteBearing(wGunLocation, enemyLocation) - wBearing)) /
						wBearingDirection) + MIDDLE_FACTOR)]++;
				} catch (Exception e) {
				}
				removeCustomEvent(this);
	    	}
	    	return false;
		}
	}
}


