package sgp;
import robocode.*;
import java.util.*;

/**
 * Environment - a class by Simon Parker
 */
public class Environment 
{
	static private AdvancedRobot robot = null;
	static public final boolean isDebugging = false;
	
	static private boolean isTurnActive = false;
	
	static public double battleFieldWidth = 1000.0;
	static public double battleFieldHeight = 1000.0;
	
	static public AdvancedRobot getRobot()
	{
		return robot;
	}

	static public void setRobot(AdvancedRobot theRobot)
	{
		robot = theRobot;		
	}

	static public TeamRobot getTeamRobot()
	{
		return (TeamRobot)robot;
	}
	
	static public void notifyStartTurn()
	{
		isTurnActive = true;
		updateRobotState();
	}
	
	static public void notifyEndTurn()
	{
		isTurnActive = false;
	}
	
	static private double velocity = 0;
	static public double getVelocity() 
	{ 
		return (isTurnActive) ? velocity : robot.getVelocity();
	}
	
	static private double heading_deg = 0;
	static public double getHeading() 
	{ 
		return (isTurnActive) ? heading_deg : robot.getHeading();
	}
	
	static private long currentTime = 0;
	static public long getTime()
	{ 
		return (isTurnActive) ? currentTime : robot.getTime();
	}
	
	static private double x = 0;
	static public double getX()
	{ 
		return (isTurnActive) ? x : robot.getX();
	}

	static private double y = 0;
	static public double getY()
	{ 
		return (isTurnActive) ? y : robot.getY();
	}
	
	static private Coordinate robotPosition = new Coordinate();
	static public Coordinate getRobotPosition()
	{ 
		if ((robotPosition == null) || !isTurnActive) 
		{	
			robotPosition.set(robot.getX(), robot.getY());
		}
		
		return robotPosition;
	}
	
	static private double energy = 100.0;
	static public double getEnergy()
	{ 
		return (isTurnActive) ? energy : robot.getEnergy();
	}
	
	static private double heading_rad = 0;
	static public double getHeadingRadians()
	{ 
		return (isTurnActive) ? heading_rad : robot.getHeadingRadians();
	}
	
	static private double gunHeading_deg = 100.0;
	static public double getGunHeading()
	{ 
		return (isTurnActive) ? gunHeading_deg : robot.getGunHeading();
	}
	
	static private double gunHeat = 100.0;
	static public double getGunHeat()
	{ 
		return (isTurnActive) ? gunHeat : robot.getGunHeat();
	}
	
	static private double radarHeading_deg = 100.0;
	static public double getRadarHeading()
	{ 
		return (isTurnActive) ? radarHeading_deg : robot.getRadarHeading();
	}
	
	static public void updateRobotState()
	{
		battleFieldWidth = robot.getBattleFieldWidth();
		battleFieldHeight = robot.getBattleFieldHeight();

		velocity = robot.getVelocity();
		heading_deg = robot.getHeading();
		x = robot.getX();
		y = robot.getY();
		energy = robot.getEnergy();
		currentTime = robot.getTime();
		heading_rad = robot.getHeadingRadians();
		gunHeading_deg = robot.getGunHeading();
		gunHeat = robot.getGunHeat();
		radarHeading_deg = robot.getRadarHeading();
		robotPosition.set(x, y);
		
	}
	
	
}