package sgp;
import robocode.*;
import java.util.*;

/**
 * JollyNinjaParameters - a class by Simon Parker
 */

public class JollyNinjaParameters
{
	private AdvancedRobot robot;
//Melee
	//movement
	public Parameter nemesisAvoidanceWeight 			= new Parameter(-100.0	, 100.0	, 0	, "nemesisAvoidanceWeight"); 		//
	public Parameter bearingDifferenceCosineWeight 	= new Parameter(0.0	, 1000.0, 274	, "bearingDifferenceCosineWeight");	//
	public Parameter optimumTargetDistance				= new Parameter(20	, 1000	, 583	, "optimumTargetDistance");			//
	public Parameter optimumTargetDistanceWeight		= new Parameter(0	, 10.0	, 7.70218		, "optimumTargetDistanceWeight");			//
	public Parameter crossfireDistanceBoundary			= new Parameter(0	, 800	, 343.55128067038964	, "crossfireDistanceBoundary");		//
	public Parameter crossfireWeight					= new Parameter(0	, 10	, 3.8628107491335495	, "crossfireWeight");
	public Parameter avoidanceExtraDistance			= new Parameter(0	, 200	, 106.80442684674671	, "avoidanceExtraDistance");		//
	public Parameter avoidanceDistanceWeight			= new Parameter(0	, 500	, 500	, "avoidanceDistanceWeight");		//
	public Parameter headingDifferenceWieght			= new Parameter(-200	, 0	, -50	, "headingDifferenceWieght");		//
	public Parameter headingHistoryOffset				= new Parameter(0	, 100	, 10	, "headingHistoryOffset");		//
	public Parameter centreDistanceWieght				= new Parameter(-1	, 1	, -0.1	, "centreDistanceWieght");		//
	public Parameter desiredPointWeight				= new Parameter(0	, 2000	, 1000	, "desiredPointWeight");		//
	public Parameter cornerOffset						= new Parameter(40	, 400	, -0.1	, "cornerOffset");		//
	public Parameter desiredPointBoundary				= new Parameter(20	, 400	, 50	, "desiredPointBoundary");		//


	//wall avoid
	public Parameter wallDistanceWeight				= new Parameter(0.1	, 1000.0	, 1000, "wallDistanceWeight");
	public Parameter wallDeflectionDistance			= new Parameter(20, 300.0	, 45	, "wallDeflectionDistance");

	//targeting
	public Parameter robotRadius 						= new Parameter(15	, 25	, 21	, "robotRadius");

	//impact avoidance
	public Parameter recentHitBulletAvoidanceWeight 	= new Parameter(0.0	, 100.0	, 3.1281239283719686	, "recentHitBulletAvoidanceWeight");		//
	public Parameter recentHitBearingWeight		 	= new Parameter(0.0	, 50.0	, 48.48231263938836	, "recentHitBearingWeight");		//
	public Parameter closestTargetBulletAvoidanceWeight = new Parameter(0.0	, 100.0	, 0		, "closestTargetBulletAvoidanceWeight");	//

	public Parameter recentHitTimeThreshold 			= new Parameter(1	, 1000	, 1000	, "recentHitTimeThreshold");				//
	public Parameter impactTimeBoundary				= new Parameter(0	, 200	, 100.77488915631217	, "impactTimeBoundary");					//
	public Parameter impactPointStillWeight			= new Parameter(0	, 10	, 3.356846716003297, "impactPointStillWeight");				//
	public Parameter impactPointLinearWeight			= new Parameter(0	, 10	, 2.944346577501222	, "impactPointLinearWeight");				//
	public Parameter impactPointCircularWeight			= new Parameter(0	, 10	, 5.643677181249718	, "impactPointCircularWeight");				//
	public Parameter impactPointPatternWeight			= new Parameter(0	, 10	, 3.4671377076037317	, "impactPointPatternWeight");				//

	public Parameter impactTimeWeight					= new Parameter(0	, 0.03	, 0.017	, "impactTimeWeight");


	public Parameter enemyBulletInfluenceTime			= new Parameter(0	, 200	, 100	, "enemyBulletInfluenceTime");
	public Parameter enemyBulletMaxDistance			= new Parameter(0	, 1200	, 150	, "enemyBulletMaxDistance");

	//target selection
	public Parameter targetDistanceWeight				= new Parameter(-100.0 / 900.0, 0			, -0.01	, "targetDistanceWeight"); //Max distance difference = 900
	public Parameter targetHitRateWeight				= new Parameter(0, 100 / 100.0				, 0		, "targetHitRateWeight"); // Max Hit Rate differnce = 100
	public Parameter targetLastTimeHitWeight			= new Parameter(-100.0 / 400.0, 0			, 0		, "targetLastTimeHitWeight"); //Max hit time diff = 400
	public Parameter targetDeltaEnergyWeight			= new Parameter(-100.0 / 1.2, 100/ 1.2		, 0		, "targetDeltaEnergyWeight"); //Max Delta Energy diff = 1.2
	public Parameter targetDeathCountWeight			= new Parameter(-100 / 0.2 , 100 / 0.2		, -400		, "targetDeathCountWeight"); //Max  = 0.6
	public Parameter targetEnergyWeight				= new Parameter(-100 / 100.0, 100 / 100.0	, 1		, "targetEnergyWeight"); // Max diff = 100
	public Parameter targetDamageToMeWeight			= new Parameter(-100 / 10.0, 100 / 10.0	, 10		, "targetDamageToMeWeight"); //Max diff = 10
	public Parameter targetDamageToHimWeight			= new Parameter(-100 / 30.0, 100 / 30.0	, 0		, "targetDamageToHimWeight"); //Max diff = 30
	public Parameter targetLastBulletPowerWeight		= new Parameter(-100 / 2.9, 100 / 2.9		, 0		, "targetLastBulletPowerWeight");//Max diff= 2.9
	public Parameter targetClosestRobotDistanceWeight	= new Parameter(-100 / 500.0, 100 / 500.0	, 0	, "targetClosestRobotDistanceWeight");//Max diff= 2.9
	public Parameter targetPredictionErrorWeight		= new Parameter(-100 / 150.0, 0			, 0	, "targetPredictionErrorWeight");//Max diff= 150

//MadHatter
	public Parameter optimumDuelTargetDistance			= new Parameter(0	, 1000	, 200	, "optimumDuelTargetDistance");
	public Parameter possibleMovementRange				= new Parameter(0	, 1000	, 60	, "possibleMovementRange");
	public Parameter minimumMoveDistance				= new Parameter(-500, 500	, 180	, "minimumMoveDistance");
	public Parameter mhWallDistanceWeight				= new Parameter(0	, 10	, 6.326530612244898	, "mhWallDistanceWeight");
	public Parameter mhTargetBearingWeight				= new Parameter(0	, 1		, 0.03	, "mhTargetBearingWeight");

//Evasion Strategy
	public Parameter evasionBulletAvoidanceWeight		= new Parameter(0	, 100	, 1		, "evasionBulletAvoidanceWeight");
	public Parameter evasionOptimumTargetDistance		= new Parameter(0	, 1000	, 200		, "evasionOptimumTargetDistance");
	public Parameter evasionOptimumTargetDistanceWeight	= new Parameter(0	, 10	, 0.1		, "evasionOptimumTargetDistanceWeight");
	public Parameter evasionBearingWeight				= new Parameter(0	, 500	, 50		, "evasionBearingWeight");
	public Parameter evasionCentreWeight				= new Parameter(0.0, 10.0	, 2		, "evasionCentreWeight");
	public Parameter evasionVelocityWeight				= new Parameter(-15.0, 0	, 0	, "evasionVelocityWeight");
	public Parameter evasionTransitionTime				= new Parameter(5, 50.0	, 20	, "evasionTransitionTime");


//bullet power (evasion)
	public Parameter hitRateThreshold					= new Parameter(0	, 100	, 13.988809593969298		, "hitRateThreshold");
	public Parameter maxDistanceDifference				= new Parameter(400	, 1200	, 0		, "maxDistanceDifference");
	public Parameter minDistance						= new Parameter(0	, 400	, 33.103882646279985		, "minDistance");

	public Parameter meleeHitRateThreshold				= new Parameter(0	, 100	, 0		, "meleeHitRateThreshold");
	public Parameter meleeMaxDistanceDifference			= new Parameter(0	, 10000	, 5000	, "meleeMaxDistanceDifference");
	public Parameter meleeMinDistance					= new Parameter(0	, 400	, 21.624886035474546		, "meleeMinDistance");
	public Parameter meleeNumOthersBulletPowerWeight	= new Parameter(0	, 10	, 1		, "meleeNumOthersBulletPowerWeight");

	public final int MAX_NUM_PARAMETERS = 50;
	public int NUM_PARAMETERS = 0;
	public Parameter[] parameterArray;

	public Optimiser optimiser = null;


	public JollyNinjaParameters()
	{
		robot = Environment.getRobot();

		parameterArray = new Parameter[MAX_NUM_PARAMETERS];

		NUM_PARAMETERS = 0;

//bullet avoidance
impactTimeBoundary.setValue(36.75281159791635);
impactPointStillWeight.setValue(3.1746663298737676);
impactPointLinearWeight.setValue(1.884731010855976);
impactPointCircularWeight.setValue(6.127156610903165);
impactPointPatternWeight.setValue(10.0);

meleeHitRateThreshold.setValue(20);


//targetDistanceWeight.setValue(-0.1111111111111111);
//targetHitRateWeight.setValue(0.7045391695280375);
//targetLastTimeHitWeight.setValue(-0.22372928479120466);
//targetDeltaEnergyWeight.setValue(68.09163004869501);
//targetDeathCountWeight.setValue(52.072671049015526);
//targetEnergyWeight.setValue(1.0);
//targetDamageToMeWeight.setValue(8.23102934698494);
//targetDamageToHimWeight.setValue(3.3333333333333335);
//targetClosestRobotDistanceWeight.setValue(0.05117566623002795);
//targetPredictionErrorWeight.setValue(-0.5682597587523925);

headingDifferenceWieght.setValue(-50.69219466133171);
headingHistoryOffset.setValue(7.881233612064478);
centreDistanceWieght.setValue(-0.14409542297082478);
recentHitBearingWeight.setValue(13.725871135509257);
nemesisAvoidanceWeight.setValue(100.0);
avoidanceExtraDistance.setValue(29.7372504120356);
avoidanceDistanceWeight.setValue(450.87383272312456);
crossfireDistanceBoundary.setValue(800.0);
crossfireWeight.setValue(6.962941653276768);
desiredPointWeight.setValue(170.9393040311221);
cornerOffset.setValue(198.5240031160182);
desiredPointBoundary.setValue(316.1148460903055);

evasionBulletAvoidanceWeight.setValue(40.97721734226024);
evasionOptimumTargetDistance.setValue(966.0737536944565);
evasionOptimumTargetDistanceWeight.setValue(4.887718460439404);
evasionBearingWeight.setValue(256.3359258841055);
evasionCentreWeight.setValue(7.930115507580692);
evasionVelocityWeight.setValue(-2.0942194836387777);
evasionTransitionTime.setValue(43.36354800505468);

		parameterArray[NUM_PARAMETERS++] = meleeHitRateThreshold			;

		parameterArray[NUM_PARAMETERS++] = targetDistanceWeight						;
		parameterArray[NUM_PARAMETERS++] = targetHitRateWeight						;
		parameterArray[NUM_PARAMETERS++] = targetLastTimeHitWeight					;
		parameterArray[NUM_PARAMETERS++] = targetDeltaEnergyWeight					;
		parameterArray[NUM_PARAMETERS++] = targetDeathCountWeight						;
		parameterArray[NUM_PARAMETERS++] = targetEnergyWeight							;
		parameterArray[NUM_PARAMETERS++] = targetDamageToMeWeight						;
		parameterArray[NUM_PARAMETERS++] = targetDamageToHimWeight					;
		parameterArray[NUM_PARAMETERS++] = targetClosestRobotDistanceWeight			;
		parameterArray[NUM_PARAMETERS++] = targetPredictionErrorWeight			;

		parameterArray[NUM_PARAMETERS++] = headingDifferenceWieght					;
		parameterArray[NUM_PARAMETERS++] = headingHistoryOffset					;
		parameterArray[NUM_PARAMETERS++] = centreDistanceWieght						;				;
		parameterArray[NUM_PARAMETERS++] = recentHitBearingWeight					;
		parameterArray[NUM_PARAMETERS++] = nemesisAvoidanceWeight              ;
		parameterArray[NUM_PARAMETERS++] = avoidanceExtraDistance	;
		parameterArray[NUM_PARAMETERS++] = avoidanceDistanceWeight	;
		parameterArray[NUM_PARAMETERS++] = crossfireDistanceBoundary	;
		parameterArray[NUM_PARAMETERS++] = crossfireWeight;

		parameterArray[NUM_PARAMETERS++] = desiredPointWeight					;
		parameterArray[NUM_PARAMETERS++] = desiredPointBoundary			;

//		parameterArray[NUM_PARAMETERS++] = evasionBulletAvoidanceWeight				;
//		parameterArray[NUM_PARAMETERS++] = evasionOptimumTargetDistance				;
//		parameterArray[NUM_PARAMETERS++] = evasionOptimumTargetDistanceWeight				;
//		parameterArray[NUM_PARAMETERS++] = evasionBearingWeight				;
//		parameterArray[NUM_PARAMETERS++] = evasionCentreWeight				;
//		parameterArray[NUM_PARAMETERS++] = evasionVelocityWeight				;
//		parameterArray[NUM_PARAMETERS++] = evasionTransitionTime				;

	//	optimiser = new EvolutionStrategy(NUM_PARAMETERS);
	//	optimiser = new BrownianOptimiser(NUM_PARAMETERS);
	
	//trial parameters
	}

	public void reset()
	{
		if (optimiser == null) return;

		optimiser.getNextParameters(parameterArray, NUM_PARAMETERS);
	}

	public void setResult(double result)
	{
		if (optimiser == null) return;

		optimiser.setResult(result);
	}

}
