/*
 * Decompiled with CFR 0.152.
 */
package divineomega.guns;

import divineomega.DivineBot;
import divineomega.GFTUtils;
import divineomega.GFTWave;
import divineomega.guns.Gun;

public class GuessFactorGun
extends Gun {
    private static final long serialVersionUID = -9120718325337766838L;
    private transient DivineBot robot;

    public GuessFactorGun(DivineBot robot) {
        this.name = "GuessFactor";
        this.robot = robot;
    }

    public void setRobot(DivineBot robot) {
        this.robot = robot;
    }

    @Override
    public double getGunTurnOffset(double gunTurn, double gunHeadingRadians, double absoluteBearing, double lateralVelocity, double bulletPower, double enemyDistance, double enemyHeading, double enemyVelocity, String enemyName, boolean isVirtual) {
        if (enemyVelocity != 0.0) {
            DivineBot.lateralDirection = GFTUtils.sign(enemyVelocity * Math.sin(enemyHeading - absoluteBearing));
        }
        GFTWave wave = new GFTWave(this.robot);
        wave.gunLocation = DivineBot.myLocation;
        GFTWave.targetLocation = GFTUtils.project(wave.gunLocation, absoluteBearing, enemyDistance);
        wave.lateralDirection = DivineBot.lateralDirection;
        wave.bulletPower = bulletPower;
        wave.setSegmentations(enemyName, enemyDistance, enemyVelocity, DivineBot.lastEnemyVelocity);
        wave.bearing = absoluteBearing;
        gunTurn = absoluteBearing - gunHeadingRadians + wave.mostVisitedBearingOffset();
        if (this.robot.getEnergy() >= bulletPower) {
            this.robot.addCustomEvent(wave);
        }
        return gunTurn;
    }
}

