/*
 * Decompiled with CFR 0.152.
 */
package florent.XSeries.radar;

import florent.XSeries.Configuration;
import florent.XSeries.gun.patternrecognition.ScanStore;
import florent.XSeries.movement.antigravity.BulletPoint;
import florent.XSeries.movement.antigravity.EnemyPoint;
import florent.XSeries.movement.antigravity.GravEntity;
import florent.XSeries.movement.antigravity.MyPoint;
import florent.XSeries.movement.wavesurfing.EnemyWave;
import florent.XSeries.movement.wavesurfing.GFLog;
import florent.XSeries.radar.PersistantData;
import florent.XSeries.radar.ScanExtrapolator;
import florent.XSeries.utils.Pluggable;
import florent.XSeries.utils.RobocodeTools;
import florent.stats.ComplexStatData;
import florent.stats.StatKeeper;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import robocode.AdvancedRobot;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.Condition;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.TeamRobot;
import robocode.WinEvent;

public class Enemy
implements Pluggable {
    public String name;
    public Point2D.Double location;
    public Point2D.Double previousLocation;
    public double energy;
    public static TeamRobot me;
    private static Point2D.Double center;
    public double timeSinceScan;
    public double lastScan;
    private double gunHeat;
    public double timeSinceVChange;
    public double lastTimeSinceVChange;
    public double heading;
    public double distance;
    public double velocity;
    public double lastVelocity;
    public double lateralVelocity;
    public double approachVelocity;
    public double absoluteBearing;
    public double lastFirePower = 2.0;
    private double timeSinceLastFire;
    private double lastFireTime;
    public double lastHit;
    private double lastCollision;
    public double runDist;
    public GFLog logDuel;
    public GFLog logMelee;
    public ScanStore store;
    public EnemyWave lastWave;
    private static Point2D.Double[] myLocation;
    public int[] myBearingDirection = new int[4];
    private static double[] myVelocity;
    private ArrayList<EnemyWave> bullets = new ArrayList(10);
    public int shots;
    public ArrayList<GravEntity> points;
    public boolean closestIsMe = false;
    public Enemy target;
    public static Rectangle2D.Double BF;
    public boolean teamMate;
    public EnemyPoint point;
    public PersistantData data;
    public double[] distances;
    public double[] velocities;
    public double[] lateralVelocities;
    private ScanExtrapolator extrapolator;
    private ScannedRobotEvent lastScanEvent;
    private double myHeading;
    private Point2D.Double lastLocation;

    static {
        myLocation = new Point2D.Double[4];
        myVelocity = new double[4];
    }

    public Enemy(TeamRobot me, String name, PersistantData data) {
        this.name = name;
        Enemy.me = me;
        this.timeSinceScan = 2.0;
        this.lastScan = -1.0;
        this.location = new Point2D.Double();
        this.previousLocation = new Point2D.Double();
        center = new Point2D.Double(me.getBattleFieldWidth() / 2.0, me.getBattleFieldHeight() / 2.0);
        BF = new Rectangle2D.Double(0.0, 0.0, me.getBattleFieldWidth(), me.getBattleFieldHeight());
        this.teamMate = Configuration.me.isTeammate(name);
        this.data = data;
        this.distances = new double[3];
        this.lateralVelocities = new double[3];
        this.velocities = new double[3];
        this.extrapolator = new ScanExtrapolator((AdvancedRobot)me);
        if (me.getOthers() == 1) {
            RobocodeTools.log("no GH " + data.VGhits[0] + "/" + data.VGrating[0] + "/" + data.VGdiffs[0]);
            RobocodeTools.log("GH " + data.VGhits[1] + "/" + data.VGrating[1] + "/" + data.VGdiffs[1]);
            RobocodeTools.log("missed scans " + (double)data.missedScans * 1.0 / ((double)data.scans + 1.0 * (double)data.missedScans));
            RobocodeTools.log("missed scans with extrapolation " + ((double)data.missedScans - (double)ScanExtrapolator.extrapolations * 1.0) / ((double)data.scans + 1.0 * (double)data.missedScans));
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        ++this.data.scans;
        if (this.lastScan > 0.0 && (double)e.getTime() - this.lastScan > 1.0) {
            this.data.missedScans = (long)((double)this.data.missedScans + ((double)e.getTime() - this.lastScan - 1.0));
        }
        if (!Configuration.melee && this.lastScan > 8.0 && (double)e.getTime() - this.lastScan == 2.0) {
            this.onScannedRobot(this.extrapolator.getScan(this.lastScanEvent, this.myHeading, this.lastLocation, e, me.getHeadingRadians(), new Point2D.Double(me.getX(), me.getY()), this.lastFirePower, this.lastFireTime));
        }
        Point2D.Double myLocation2 = new Point2D.Double(me.getX(), me.getY());
        ComplexStatData data2 = StatKeeper.getInstance().getStatData("Scan interval");
        this.previousLocation.setLocation(this.location.x, this.location.y);
        this.location.setLocation(RobocodeTools.projectMotion(myLocation2, me.getHeadingRadians() + e.getBearingRadians(), e.getDistance()));
        this.data.lastKnownLocation = this.location;
        this.name = e.getName();
        if (!me.isTeammate(e.getName())) {
            double eDrop = this.energy - e.getEnergy();
            this.energy = e.getEnergy();
            this.heading = e.getHeadingRadians();
            this.lastVelocity = this.velocity;
            this.velocity = e.getVelocity();
            if (Math.abs(this.lastVelocity - this.velocity) > 0.5) {
                this.lastTimeSinceVChange = this.timeSinceVChange;
                this.timeSinceVChange = 0.0;
                this.runDist = 0.0;
            }
            this.runDist += this.velocity;
            this.approachVelocity = -this.velocity * Math.cos(e.getHeadingRadians() - (me.getHeadingRadians() + e.getBearingRadians()));
            this.data.approachVelocity = RobocodeTools.rollingAverage(Math.min(this.data.scans, 500), this.data.approachVelocity, this.approachVelocity);
            this.distance = e.getDistance();
            this.absoluteBearing = me.getHeadingRadians() + e.getBearingRadians();
            this.lateralVelocity = this.velocity * Math.sin(e.getHeadingRadians() - this.absoluteBearing);
            int i = 1;
            while (i >= 0) {
                this.distances[i + 1] = this.distances[i];
                this.velocities[i + 1] = this.velocities[i];
                this.lateralVelocities[i + 1] = this.lateralVelocities[i];
                --i;
            }
            this.distances[0] = e.getDistance();
            this.velocities[0] = me.getVelocity();
            this.lateralVelocities[0] = me.getVelocity() * Math.sin(me.getHeadingRadians() - RobocodeTools.absoluteBearing(this.location, myLocation2));
            boolean wallHit = false;
            this.gunHeat = 1.0 + this.lastFirePower / 5.0 - this.timeSinceLastFire * me.getGunCoolingRate();
            if (e.getVelocity() == 0.0 && Math.abs(this.lastVelocity) > 2.0 * this.timeSinceScan && this.lastCollision != (double)e.getTime()) {
                RobocodeTools.log(String.valueOf(e.getName()) + " hits a wall");
                wallHit = true;
            }
            if (eDrop > 0.0 && eDrop <= 3.0) {
                if (wallHit && this.gunHeat > 0.1) {
                    System.out.println("false fire detection: gun heat = " + this.gunHeat);
                    this.addWave(this.lastFirePower, e, false);
                } else {
                    this.timeSinceLastFire = 0.0;
                    this.addWave(eDrop, e, true);
                    this.lastFirePower = eDrop;
                    this.lastFireTime = e.getTime();
                    ++this.shots;
                }
            } else {
                this.addWave(this.lastFirePower, e, false);
            }
        }
        this.timeSinceScan = 0.0;
        if (me.getOthers() > 1 && this.lastScan != -1.0) {
            data2.record((double)e.getTime() - this.lastScan);
        }
        this.lastScan = e.getTime();
        this.lastScanEvent = e;
        this.myHeading = me.getHeadingRadians();
        this.lastLocation = myLocation[0];
    }

    public String getName() {
        return this.name;
    }

    public void updateEnemyPoint(EnemyPoint point) {
        point.point = this.location;
    }

    public void onRobotDeath(RobotDeathEvent e) {
    }

    public void onHitWall(HitWallEvent e) {
    }

    public void onHitRobot(HitRobotEvent e) {
        this.lastCollision = e.getTime();
        this.energy -= 0.6;
    }

    public void onHitByBullet(HitByBulletEvent e) {
        Point2D.Double impact = new Point2D.Double(e.getBullet().getX(), e.getBullet().getY());
        EnemyWave wave = this.getClosestWave(impact, e.getTime());
        if (wave != null && Math.abs(wave.distanceToImpact(impact, e.getTime())) < 2.0 * wave.velocity) {
            wave.onHitByBullet(e);
            if (wave.distance > 150.0) {
                ++this.data.rangeHits;
            }
        } else {
            System.out.println("wave not found");
        }
        this.energy += 3.0 * e.getPower();
        this.lastHit = e.getTime();
    }

    public void onBulletMissed(BulletMissedEvent e) {
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
        Point2D.Double impact = new Point2D.Double(e.getBullet().getX(), e.getBullet().getY());
        EnemyWave wave = this.getClosestWave(impact, e.getTime());
        if (wave != null && Math.abs(wave.distanceToImpact(impact, e.getTime())) < 2.0 * wave.velocity) {
            wave.onBulletHitBullet(e);
            this.remove(wave);
        } else {
            System.out.println("wave not found bhb");
        }
    }

    public void onBulletHit(BulletHitEvent e) {
        ++this.data.myHits;
        this.energy -= 4.0 * e.getBullet().getPower() + (e.getBullet().getPower() > 1.0 ? 2.0 * (e.getBullet().getPower() - 1.0) : 0.0);
    }

    public void onSkippedTurn(SkippedTurnEvent e) {
    }

    public void onPaint(Graphics2D g) {
        g.setColor(Color.green);
        g.drawOval((int)(this.location.x - 25.0), (int)(Configuration.battleFieldHeigth - this.location.y - 25.0), 50, 50);
        g.drawString(this.name, (int)(this.location.x - 25.0), (int)(Configuration.battleFieldHeigth - this.location.y - 25.0));
        if (me.getOthers() < 2) {
            int i = 0;
            while (i < this.bullets.size()) {
                this.bullets.get(i).onPaint(g);
                ++i;
            }
        }
    }

    public void onWin(WinEvent e) {
    }

    public void onDeath(DeathEvent e) {
    }

    public void onMainLoop() {
        this.timeSinceScan += 1.0;
        this.timeSinceVChange += 1.0;
        this.newTick();
    }

    public void initRound() {
        this.bullets = new ArrayList(10);
    }

    public void endRound() {
    }

    public boolean isHeadOn() {
        if (me.getOthers() > 1) {
            return 1.0 * (double)this.logMelee.headOnHit / (1.0 * (double)this.logMelee.hit) > 0.6;
        }
        return 1.0 * (double)this.logDuel.headOnHit / (1.0 * (double)this.logDuel.hit) > 0.6;
    }

    public boolean flattenner() {
        if (me.getOthers() > 1) {
            return 1.0 * (double)this.logMelee.goodHit / (1.0 * (double)this.logMelee.hit) < 0.55;
        }
        return 1.0 * (double)this.logDuel.goodHit / (1.0 * (double)this.logDuel.hit) < 0.55;
    }

    public void dump() {
        RobocodeTools.log("rammer " + this.isRammer());
        RobocodeTools.log("headOn : " + this.isHeadOn() + " : " + 1.0 * (double)this.logDuel.headOnHit / (1.0 * (double)this.logDuel.hit));
        RobocodeTools.log("flattener : " + this.flattenner() + " : " + 1.0 * (double)this.logDuel.goodHit / (1.0 * (double)this.logDuel.hit) + "|" + (double)this.data.rangeHits / ((double)me.getRoundNum() + 1.0));
    }

    public void remove(EnemyWave wave) {
        this.bullets.remove((Object)wave);
        if (this.points != null) {
            this.points.remove(wave.point);
        }
    }

    public EnemyWave getClosestWave(Point2D.Double location, double time) {
        EnemyWave closestWave = null;
        double bestDistance = Double.POSITIVE_INFINITY;
        int i = 0;
        while (i < this.bullets.size()) {
            EnemyWave wave = this.bullets.get(i);
            if (Math.abs(wave.distanceToImpact(location, time)) < bestDistance) {
                bestDistance = Math.abs(wave.distanceToImpact(location, time));
                closestWave = wave;
            }
            ++i;
        }
        return closestWave;
    }

    public EnemyWave getNearestWave(Point2D.Double location, double time) {
        EnemyWave nearestWave = null;
        double bestDistance = Double.POSITIVE_INFINITY;
        int i = 0;
        while (i < this.bullets.size()) {
            EnemyWave wave = this.bullets.get(i);
            double d = wave.distanceToImpact(location, time);
            if (wave.surfable && d < bestDistance && d > 18.0) {
                bestDistance = wave.distanceToImpact(location, time);
                nearestWave = wave;
            }
            ++i;
        }
        return nearestWave;
    }

    private void addWave(double power, ScannedRobotEvent e, boolean fired) {
        double heatTime;
        GFLog log = me.getOthers() > 1 ? this.logMelee : this.logDuel;
        EnemyWave wave = new EnemyWave(this);
        if (this.previousLocation == null) {
            this.previousLocation = RobocodeTools.projectMotion(myLocation[0], me.getHeadingRadians() + e.getBearingRadians(), e.getDistance());
        }
        wave.init(this.previousLocation, myLocation[0], this.myBearingDirection[0], power, myVelocity[1], RobocodeTools.absoluteBearing(this.previousLocation, myLocation[0]), e.getTime() - 1L);
        if (Configuration.others == 1) {
            wave.segment(this.distances[1], myVelocity[1], this.lateralVelocities[1], myLocation[1], power);
        } else {
            wave.segment(this.distance, myVelocity[0], this.lateralVelocity, myLocation[0], power);
        }
        if (log != null) {
            if (fired) {
                this.bullets.add(wave);
                if (this.points != null) {
                    BulletPoint point = new BulletPoint(wave);
                    point.point = wave.predictedLocation();
                    wave.point = point;
                    this.points.add(point);
                }
            }
            me.addCustomEvent((Condition)wave);
        }
        this.lastWave = this.timeSinceLastFire > (heatTime = (1.0 + this.lastFirePower / 5.0) / me.getGunCoolingRate()) && this.timeSinceLastFire % heatTime == 0.0 || this.timeSinceLastFire <= heatTime ? wave : this.lastWave;
    }

    public static void newTickClass() {
        int i = 2;
        while (i >= 0) {
            Enemy.myLocation[i + 1] = myLocation[i];
            Enemy.myVelocity[i + 1] = myVelocity[i];
            --i;
        }
        Enemy.myLocation[0] = new Point2D.Double(me.getX(), me.getY());
        Enemy.myVelocity[0] = me.getVelocity();
        if (myLocation[3] == null) {
            i = 0;
            while (i < 3) {
                Enemy.myLocation[i + 1] = myLocation[i];
                Enemy.myVelocity[i + 1] = myVelocity[i];
                ++i;
            }
        }
        if (MyPoint.getInstance().point != null) {
            MyPoint.getInstance().point.setLocation(myLocation[3]);
        }
    }

    public void newTick() {
        int i = 2;
        while (i >= 0) {
            this.myBearingDirection[i + 1] = this.myBearingDirection[i];
            --i;
        }
        this.myBearingDirection[0] = this.location == null ? 1 : (myVelocity[0] * Math.sin(me.getHeadingRadians() - RobocodeTools.absoluteBearing(this.location, myLocation[0])) < 0.0 ? -1 : 1);
        this.timeSinceLastFire = (double)me.getTime() - this.lastFireTime;
    }

    public double distanceToWall() {
        return this.lastWave.wallDistance(1.0, BF);
    }

    public double distanceToCenter() {
        return center.distance(this.location);
    }

    public boolean isSkyClear() {
        return this.timeSinceLastFire > 1.3 * this.location.distance(myLocation[0]) / RobocodeTools.bulletVelocity(this.lastFirePower);
    }

    public boolean isRammer() {
        return this.data.approachVelocity > 4.5;
    }

    public boolean isHoldingFire() {
        return this.gunHeat < -1.6;
    }

    public void updateWaveOnHitByBullet() {
        int i = 0;
        while (i < this.bullets.size()) {
            this.bullets.get((int)i).point.closestIsMe = true;
            ++i;
        }
    }
}

