/*
 * Decompiled with CFR 0.152.
 */
package florent.XSeries.team;

import florent.XSeries.Configuration;
import florent.XSeries.movement.AntiGravity;
import florent.XSeries.movement.MovementFactory;
import florent.XSeries.movement.MovementType;
import florent.XSeries.movement.antigravity.TeamBulletPoint;
import florent.XSeries.radar.BotType;
import florent.XSeries.radar.Tracker;
import florent.XSeries.team.RemoveBullet;
import florent.XSeries.team.TeamBullet;
import florent.XSeries.team.TeamLocation;
import florent.XSeries.team.TeamMessage;
import florent.XSeries.team.TeamScan;
import florent.XSeries.team.XBullet;
import florent.XSeries.utils.Pluggable;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.HashMap;
import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.MessageEvent;
import robocode.ScannedRobotEvent;
import robocode.TeamRobot;

public class Xmen
extends TeamRobot
implements Pluggable {
    protected HashMap<String, Double> lastScans;
    protected HashMap<Bullet, XBullet> myBullets = new HashMap();
    protected boolean rejectScan = false;
    protected boolean teamMsg = false;
    public BotType type;
    protected double maxVelocity = 8.0;

    public void onMessageReceived(MessageEvent e) {
        try {
            TeamMessage msg = (TeamMessage)e.getMessage();
            this.teamMsg = true;
            msg.executeMessage(this);
            this.teamMsg = false;
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.rejectScan = false;
        if (this.lastScans == null) {
            this.lastScans = new HashMap();
        }
        Double lastScan = this.lastScans.remove(e.getName());
        if (e.getName().equals(this.getName()) || lastScan != null && lastScan == (double)e.getTime()) {
            this.rejectScan = true;
            return;
        }
        this.lastScans.put(e.getName(), new Double(e.getTime()));
        if (!this.teamMsg) {
            TeamScan msg = new TeamScan(e, this.getX(), this.getY(), this.getHeadingRadians());
            try {
                this.broadcastMessage(msg);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    public void addBullet(XBullet bullet) {
        AntiGravity aGrav = (AntiGravity)MovementFactory.getInstance().getStrategy(MovementType.ANTIGRAVITYMOVEMENT);
        aGrav.addGravEntity(new TeamBulletPoint(bullet));
    }

    public void removeBullet(XBullet bullet) {
        AntiGravity aGrav = (AntiGravity)MovementFactory.getInstance().getStrategy(MovementType.ANTIGRAVITYMOVEMENT);
        aGrav.removeGravEntity(new TeamBulletPoint(bullet));
    }

    public void onFire(Bullet bullet) {
        if (bullet == null) {
            System.out.println("bullet == null");
        }
        if (!Configuration.team) {
            return;
        }
        XBullet xBullet = new XBullet(new Point2D.Double(bullet.getX(), bullet.getY()), bullet.getVelocity(), bullet.getHeadingRadians(), this.getTime());
        this.myBullets.put(bullet, xBullet);
        TeamBullet msg = new TeamBullet(new Point2D.Double(xBullet.originX, xBullet.originY), xBullet.velocity, xBullet.heading, xBullet.fireTime);
        try {
            this.broadcastMessage(msg);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public void onBulletHit(BulletHitEvent e) {
        XBullet bullet = this.myBullets.remove(e.getBullet());
        RemoveBullet msg = new RemoveBullet(bullet);
        try {
            this.broadcastMessage(msg);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
        XBullet bullet = this.myBullets.remove(e.getBullet());
        RemoveBullet msg = new RemoveBullet(bullet);
        try {
            this.broadcastMessage(msg);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public void onBulletMissed(BulletMissedEvent e) {
        XBullet bullet = this.myBullets.remove(e.getBullet());
        RemoveBullet msg = new RemoveBullet(bullet);
        try {
            this.broadcastMessage(msg);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public void onMainLoop() {
        TeamLocation msg = new TeamLocation(this.getName(), this.getX(), this.getY());
        try {
            this.broadcastMessage(msg);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setMaxVelocity(double arg0) {
        this.maxVelocity = arg0;
        super.setMaxVelocity(arg0);
    }

    public double getMaxVelocity() {
        return this.maxVelocity;
    }

    public void initRound() {
    }

    public void endRound() {
    }

    public int getEnmiesAlive() {
        String[] mates = this.getTeammates();
        if (mates == null) {
            return this.getOthers();
        }
        int friends = 0;
        int i = 0;
        while (i < mates.length) {
            friends += Tracker.getInstance().isDead(mates[i]) ? 0 : 1;
            ++i;
        }
        return Math.max(this.getOthers() - friends, 0);
    }
}

