/*
 * Decompiled with CFR 0.152.
 */
package jaybot.guns;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import jaybot.bots.BaseBot;
import jaybot.guns.BaseGun;
import jaybot.guns.FiringSolution;
import jaybot.guns.Gun;
import jaybot.intel.Enemy;

public class LinearTargetting
extends BaseGun {
    public static final String GUN_NAME = "Linear";
    private static LinearTargetting _$2133 = new LinearTargetting();

    public String getGunName() {
        return GUN_NAME;
    }

    public static Gun getInternalInstance() {
        return _$2133;
    }

    public FiringSolution buildFiringSolution(BaseBot myBot, Enemy badGuy, double powerOverride) {
        return this.buildFiringSolutionInternal(myBot, badGuy, powerOverride);
    }

    public FiringSolution buildFiringSolution(BaseBot myBot, Enemy badGuy) {
        return this.buildFiringSolutionInternal(myBot, badGuy, Double.NEGATIVE_INFINITY);
    }

    protected FiringSolution buildFiringSolutionInternal(BaseBot myBot, Enemy badGuy, double optionalPower) {
        if (!badGuy.canDetermineFuturePosition()) {
            return null;
        }
        Point2D.Double myLocation = new Point2D.Double(myBot.getX(), myBot.getY());
        Point2D.Double badGuyLocation = new Point2D.Double(badGuy.getLastKnownX(), badGuy.getLastKnownY());
        Point2D badGuyNextLocation = badGuyLocation;
        double badGuyDistance = myLocation.distance(badGuyLocation);
        double shotPower = optionalPower;
        if (shotPower == Double.NEGATIVE_INFINITY) {
            shotPower = myBot.getBestBulletPowerForDistance(badGuyDistance, this.getRunningShotAccuracy());
        }
        double newDistance = badGuyDistance;
        double badGuyHeading = 0.0;
        if (badGuy.getLastKnownVelocity() != 0.0) {
            badGuyHeading = Math.toRadians(badGuy.getLastKnownHeading());
        }
        double badGuyVelocity = badGuy.getLastKnownVelocity();
        double bulletVelocity = BaseBot.getBulletVelocityFromPower(shotPower);
        int iterationCount = 0;
        boolean hitWall = false;
        double oldTime = 0.0;
        double newTime = badGuyDistance / bulletVelocity;
        double targetBearing = myBot.headingToBearingDegrees(BaseBot.getAngleBetweenPointsInDegrees(myLocation, badGuyNextLocation));
        Rectangle2D.Double fieldRect = new Rectangle2D.Double(0.0, 0.0, myBot.getBattleFieldWidth(), myBot.getBattleFieldHeight());
        while (!hitWall && iterationCount < 20 && Math.abs(oldTime - newTime) > 1.0E-4) {
            ++iterationCount;
            oldTime = newTime;
            badGuyNextLocation = BaseBot.pointFromCoords(((Point2D)badGuyLocation).getX() + Math.sin(badGuyHeading) * badGuyVelocity * oldTime, ((Point2D)badGuyLocation).getY() + Math.cos(badGuyHeading) * badGuyVelocity * oldTime);
            if (!fieldRect.contains(badGuyNextLocation)) {
                hitWall = true;
                if (badGuyNextLocation.getY() < fieldRect.getMinX()) {
                    badGuyNextLocation.setLocation(badGuyNextLocation.getX(), fieldRect.getMinX());
                }
                if (badGuyNextLocation.getX() < fieldRect.getMinY()) {
                    badGuyNextLocation.setLocation(fieldRect.getMinY(), badGuyNextLocation.getY());
                }
                if (badGuyNextLocation.getX() > myBot.getBattleFieldWidth()) {
                    badGuyNextLocation.setLocation(myBot.getBattleFieldWidth(), badGuyNextLocation.getY());
                }
                if (badGuyNextLocation.getY() > myBot.getBattleFieldHeight()) {
                    badGuyNextLocation.setLocation(badGuyNextLocation.getX(), myBot.getBattleFieldHeight());
                }
            }
            targetBearing = myBot.headingToBearingDegrees(BaseBot.getAngleBetweenPointsInDegrees(myLocation, badGuyNextLocation));
            newDistance = myLocation.distance(badGuyNextLocation);
            newTime = newDistance / bulletVelocity;
        }
        FiringSolution solution = new FiringSolution(this.getGunName(), badGuy.getName(), targetBearing, newDistance, shotPower);
        solution.setAimPoint(badGuyNextLocation);
        return solution;
    }
}

