/*
 * Decompiled with CFR 0.152.
 */
package gre.svman4.morfeas;

import gre.svman4.WaveBullet;
import gre.svman4.useful.FieldPoint;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import robocode.util.Utils;

public class EnemyWaveBullet
extends WaveBullet {
    private Color getColor(double lower, double val, double higher) {
        double range = higher - lower;
        double value = Math.min(range, Math.max(val - lower, 0.0));
        double H = (range - value) / range * 0.4;
        double S = 0.9;
        double B = 0.9;
        return Color.getHSBColor((float)H, (float)S, (float)B);
    }

    public float[] getEnemyCurrentStatus() {
        return this.enemy.getEnemyGunCurrentStatus(Math.abs(this.mineRobotVelocity), this.distanceToEnemyPosition, this.relativePosition);
    }

    double getshootingAngle(int OffsetBin) {
        double factor = (2.0 * (double)OffsetBin - 61.0 - 1.0) / 60.0;
        double offsetAngle = factor * this.enemy.getMaxEscapeAngle(this.bulletVelocity * (double)this.lateralDirection);
        double shootingAngle = offsetAngle + this.directAngle;
        return shootingAngle;
    }

    private Stroke getStroke(double min, double d, double max) {
        double range = max - min;
        double val = d - min;
        return new BasicStroke((float)(val / range) * 8.0f);
    }

    public void logEnemyHit(FieldPoint hitPoint) {
        this.enemy.logEnemyHit(this, this.getOffsetAngle(hitPoint));
    }

    public double getOffsetAngle(FieldPoint targetLocation) {
        double offsetAngle = this.fireLocation.getAngleTo(targetLocation) - this.directAngle;
        return Utils.normalRelativeAngle((double)offsetAngle);
    }

    public void onPaint(Graphics2D g) {
        float[] curStats = this.getEnemyCurrentStatus();
        g.setColor(Color.DARK_GRAY);
        double max = Double.MIN_VALUE;
        double min = Double.MAX_VALUE;
        for (int j = 0; j < 61; ++j) {
            if ((double)curStats[j] < min) {
                min = curStats[j];
                continue;
            }
            if (!((double)curStats[j] > max)) continue;
            max = curStats[j];
        }
        double range = max - min;
        FieldPoint temp1 = new FieldPoint();
        temp1.setLocation(this.fireLocation.project(this.distanceTraveled - 2.0 * this.bulletVelocity, this.getshootingAngle(0)));
        FieldPoint temp0 = this.fireLocation.project(this.distanceTraveled, this.directAngle);
        g.drawLine((int)this.fireLocation.x, (int)this.fireLocation.y, (int)temp0.x, (int)temp0.y);
        for (int j = 1; j < 61; ++j) {
            temp0.setLocation(temp1);
            temp1.setLocation(this.fireLocation.project(this.distanceTraveled - 2.0 * this.bulletVelocity, this.getshootingAngle(j)));
            g.setColor(this.getColor(min, curStats[j], max));
            float val = (float)((double)curStats[j] - min);
            float radius = (float)((double)val / range * 3.0 + 0.5);
            g.fillOval((int)(temp1.x - (double)radius), (int)(temp1.y - (double)radius), (int)radius * 2, (int)radius * 2);
        }
    }
}

